/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.configurator.parser.model;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.rpc.cluster.configurator.parser.model.ConfigItem;

public class ConfiguratorConfig {
    public static final String SCOPE_SERVICE = "service";
    public static final String SCOPE_APPLICATION = "application";
    private String configVersion;
    private String scope;
    private String key;
    private Boolean enabled = true;
    private List<ConfigItem> configs;

    public static ConfiguratorConfig parseFromMap(Map<String, Object> map) {
        Object configs;
        ConfiguratorConfig configuratorConfig = new ConfiguratorConfig();
        configuratorConfig.setConfigVersion((String)map.get("configVersion"));
        configuratorConfig.setScope((String)map.get("scope"));
        configuratorConfig.setKey((String)map.get("key"));
        Object enabled = map.get("enabled");
        if (enabled != null) {
            configuratorConfig.setEnabled(Boolean.parseBoolean(enabled.toString()));
        }
        if ((configs = map.get("configs")) != null && List.class.isAssignableFrom(configs.getClass())) {
            configuratorConfig.setConfigs(((List)configs).stream().map(ConfigItem::parseFromMap).collect(Collectors.toList()));
        }
        return configuratorConfig;
    }

    public String getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(String configVersion) {
        this.configVersion = configVersion;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<ConfigItem> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<ConfigItem> configs) {
        this.configs = configs;
    }
}

