/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.merger;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.cluster.Merger;
import org.apache.dubbo.rpc.cluster.merger.ArrayMerger;

public class MergerFactory {
    private static final ConcurrentMap<Class<?>, Merger<?>> MERGER_CACHE = new ConcurrentHashMap();

    public static <T> Merger<T> getMerger(Class<T> returnType) {
        Merger result;
        if (returnType == null) {
            throw new IllegalArgumentException("returnType is null");
        }
        if (returnType.isArray()) {
            Class<?> type = returnType.getComponentType();
            result = (Merger)MERGER_CACHE.get(type);
            if (result == null) {
                MergerFactory.loadMergers();
                result = (Merger)MERGER_CACHE.get(type);
            }
            if (result == null && !type.isPrimitive()) {
                result = ArrayMerger.INSTANCE;
            }
        } else {
            result = (Merger)MERGER_CACHE.get(returnType);
            if (result == null) {
                MergerFactory.loadMergers();
                result = (Merger)MERGER_CACHE.get(returnType);
            }
        }
        return result;
    }

    static void loadMergers() {
        Set names = ExtensionLoader.getExtensionLoader(Merger.class).getSupportedExtensions();
        for (String name : names) {
            Merger m = (Merger)ExtensionLoader.getExtensionLoader(Merger.class).getExtension(name);
            MERGER_CACHE.putIfAbsent(ReflectUtils.getGenericClass(m.getClass()), m);
        }
    }
}

