/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;

@SPI(value="failover")
public interface Cluster {
    public static final String DEFAULT = "failover";

    @Adaptive
    public <T> Invoker<T> join(Directory<T> var1) throws RpcException;

    public static Cluster getCluster(String name) {
        return Cluster.getCluster(name, true);
    }

    public static Cluster getCluster(String name, boolean wrap) {
        if (StringUtils.isEmpty((String)name)) {
            name = DEFAULT;
        }
        return (Cluster)ExtensionLoader.getExtensionLoader(Cluster.class).getExtension(name, wrap);
    }
}

