/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.registry;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import org.apache.dubbo.rpc.cluster.support.wrapper.MockClusterInvoker;

public class ZoneAwareClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(ZoneAwareClusterInvoker.class);

    public ZoneAwareClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        Invoker<T> invoker2;
        for (Invoker<T> invoker3 : invokers) {
            MockClusterInvoker mockClusterInvoker = (MockClusterInvoker)invoker3;
            if (!mockClusterInvoker.isAvailable() || !mockClusterInvoker.getRegistryUrl().getParameter("registry.preferred", false)) continue;
            return mockClusterInvoker.invoke(invocation);
        }
        String zone = invocation.getAttachment("registry_zone");
        if (StringUtils.isNotEmpty((String)zone)) {
            for (Invoker<T> invoker4 : invokers) {
                MockClusterInvoker mockClusterInvoker = (MockClusterInvoker)invoker4;
                if (!mockClusterInvoker.isAvailable() || !zone.equals(mockClusterInvoker.getRegistryUrl().getParameter("registry.zone"))) continue;
                return mockClusterInvoker.invoke(invocation);
            }
            String string = invocation.getAttachment("registry_zone_force");
            if (StringUtils.isNotEmpty((String)string) && "true".equalsIgnoreCase(string)) {
                throw new IllegalStateException("No registry instance in zone or no available providers in the registry, zone: " + zone + ", registries: " + invokers.stream().map(invoker -> ((MockClusterInvoker)invoker).getRegistryUrl().toString()).collect(Collectors.joining(",")));
            }
        }
        if ((invoker2 = this.select(loadbalance, invocation, invokers, null)).isAvailable()) {
            return invoker2.invoke(invocation);
        }
        for (Invoker<T> invoker4 : invokers) {
            MockClusterInvoker mockClusterInvoker = (MockClusterInvoker)invoker4;
            if (!mockClusterInvoker.isAvailable()) continue;
            return mockClusterInvoker.invoke(invocation);
        }
        throw new RpcException("No provider available in " + invokers);
    }
}

