/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mock;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;

public class MockInvokersSelector
extends AbstractRouter {
    public static final String NAME = "MOCK_ROUTER";
    private static final int MOCK_INVOKERS_DEFAULT_PRIORITY = Integer.MIN_VALUE;

    public MockInvokersSelector() {
        this.priority = Integer.MIN_VALUE;
    }

    @Override
    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        if (CollectionUtils.isEmpty(invokers)) {
            return invokers;
        }
        if (invocation.getObjectAttachments() == null) {
            return this.getNormalInvokers(invokers);
        }
        String value = (String)invocation.getObjectAttachments().get("invocation.need.mock");
        if (value == null) {
            return this.getNormalInvokers(invokers);
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return this.getMockedInvokers(invokers);
        }
        return invokers;
    }

    private <T> List<Invoker<T>> getMockedInvokers(List<Invoker<T>> invokers) {
        if (!this.hasMockProviders(invokers)) {
            return null;
        }
        ArrayList<Invoker<T>> sInvokers = new ArrayList<Invoker<T>>(1);
        for (Invoker<T> invoker : invokers) {
            if (!invoker.getUrl().getProtocol().equals("mock")) continue;
            sInvokers.add(invoker);
        }
        return sInvokers;
    }

    private <T> List<Invoker<T>> getNormalInvokers(List<Invoker<T>> invokers) {
        if (!this.hasMockProviders(invokers)) {
            return invokers;
        }
        ArrayList<Invoker<T>> sInvokers = new ArrayList<Invoker<T>>(invokers.size());
        for (Invoker<T> invoker : invokers) {
            if (invoker.getUrl().getProtocol().equals("mock")) continue;
            sInvokers.add(invoker);
        }
        return sInvokers;
    }

    private <T> boolean hasMockProviders(List<Invoker<T>> invokers) {
        boolean hasMockProvider = false;
        for (Invoker<T> invoker : invokers) {
            if (!invoker.getUrl().getProtocol().equals("mock")) continue;
            hasMockProvider = true;
            break;
        }
        return hasMockProvider;
    }
}

