/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.loadbalance;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.io.Bytes;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;
import org.apache.dubbo.rpc.support.RpcUtils;

public class ConsistentHashLoadBalance
extends AbstractLoadBalance {
    public static final String NAME = "consistenthash";
    public static final String HASH_NODES = "hash.nodes";
    public static final String HASH_ARGUMENTS = "hash.arguments";
    private final ConcurrentMap<String, ConsistentHashSelector<?>> selectors = new ConcurrentHashMap();

    @Override
    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        String methodName = RpcUtils.getMethodName((Invocation)invocation);
        String key = invokers.get(0).getUrl().getServiceKey() + "." + methodName;
        int invokersHashCode = this.getCorrespondingHashCode(invokers);
        ConsistentHashSelector selector = (ConsistentHashSelector)this.selectors.get(key);
        if (selector == null || selector.identityHashCode != invokersHashCode) {
            this.selectors.put(key, new ConsistentHashSelector<T>(invokers, methodName, invokersHashCode));
            selector = (ConsistentHashSelector)this.selectors.get(key);
        }
        return selector.select(invocation);
    }

    public <T> int getCorrespondingHashCode(List<Invoker<T>> invokers) {
        return invokers.hashCode();
    }

    private static final class ConsistentHashSelector<T> {
        private final TreeMap<Long, Invoker<T>> virtualInvokers;
        private final int replicaNumber;
        private final int identityHashCode;
        private final int[] argumentIndex;
        private Map<String, AtomicLong> serverRequestCountMap = new ConcurrentHashMap<String, AtomicLong>();
        private AtomicLong totalRequestCount;
        private int serverCount;
        private static final double OVERLOAD_RATIO_THREAD = 1.5;

        ConsistentHashSelector(List<Invoker<T>> invokers, String methodName, int identityHashCode) {
            this.virtualInvokers = new TreeMap();
            this.identityHashCode = identityHashCode;
            URL url = invokers.get(0).getUrl();
            this.replicaNumber = url.getMethodParameter(methodName, ConsistentHashLoadBalance.HASH_NODES, 160);
            String[] index = CommonConstants.COMMA_SPLIT_PATTERN.split(url.getMethodParameter(methodName, ConsistentHashLoadBalance.HASH_ARGUMENTS, "0"));
            this.argumentIndex = new int[index.length];
            for (int i = 0; i < index.length; ++i) {
                this.argumentIndex[i] = Integer.parseInt(index[i]);
            }
            for (Invoker<T> invoker : invokers) {
                String address = invoker.getUrl().getAddress();
                for (int i = 0; i < this.replicaNumber / 4; ++i) {
                    byte[] digest = Bytes.getMD5((String)(address + i));
                    for (int h = 0; h < 4; ++h) {
                        long m = this.hash(digest, h);
                        this.virtualInvokers.put(m, invoker);
                    }
                }
            }
            this.totalRequestCount = new AtomicLong(0L);
            this.serverCount = invokers.size();
            this.serverRequestCountMap.clear();
        }

        public Invoker<T> select(Invocation invocation) {
            String key = this.toKey(invocation.getArguments());
            byte[] digest = Bytes.getMD5((String)key);
            return this.selectForKey(this.hash(digest, 0));
        }

        private String toKey(Object[] args) {
            StringBuilder buf = new StringBuilder();
            for (int i : this.argumentIndex) {
                if (i < 0 || i >= args.length) continue;
                buf.append(args[i]);
            }
            return buf.toString();
        }

        private Invoker<T> selectForKey(long hash) {
            Map.Entry<Long, Invoker<T>> entry = this.virtualInvokers.ceilingEntry(hash);
            if (entry == null) {
                entry = this.virtualInvokers.firstEntry();
            }
            String serverAddress = entry.getValue().getUrl().getAddress();
            double overloadThread = (double)this.totalRequestCount.get() / (double)this.serverCount * 1.5;
            while (this.serverRequestCountMap.containsKey(serverAddress) && (double)this.serverRequestCountMap.get(serverAddress).get() >= overloadThread) {
                entry = this.getNextInvokerNode(this.virtualInvokers, entry);
                serverAddress = entry.getValue().getUrl().getAddress();
            }
            if (!this.serverRequestCountMap.containsKey(serverAddress)) {
                this.serverRequestCountMap.put(serverAddress, new AtomicLong(1L));
            } else {
                this.serverRequestCountMap.get(serverAddress).incrementAndGet();
            }
            this.totalRequestCount.incrementAndGet();
            return entry.getValue();
        }

        private Map.Entry<Long, Invoker<T>> getNextInvokerNode(TreeMap<Long, Invoker<T>> virtualInvokers, Map.Entry<Long, Invoker<T>> entry) {
            Map.Entry<Long, Invoker<T>> nextEntry = virtualInvokers.higherEntry(entry.getKey());
            if (nextEntry == null) {
                return virtualInvokers.firstEntry();
            }
            return nextEntry;
        }

        private long hash(byte[] digest, int number) {
            return ((long)(digest[3 + number * 4] & 0xFF) << 24 | (long)(digest[2 + number * 4] & 0xFF) << 16 | (long)(digest[1 + number * 4] & 0xFF) << 8 | (long)(digest[number * 4] & 0xFF)) & 0xFFFFFFFFL;
        }
    }
}

