/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.support.wrapper;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.support.MockInvoker;

public class MockClusterInvoker<T>
implements ClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(MockClusterInvoker.class);
    private final Directory<T> directory;
    private final Invoker<T> invoker;

    public MockClusterInvoker(Directory<T> directory, Invoker<T> invoker) {
        this.directory = directory;
        this.invoker = invoker;
    }

    public URL getUrl() {
        return this.directory.getConsumerUrl();
    }

    @Override
    public URL getRegistryUrl() {
        return this.directory.getUrl();
    }

    @Override
    public Directory<T> getDirectory() {
        return this.directory;
    }

    @Override
    public boolean isDestroyed() {
        return this.directory.isDestroyed();
    }

    public boolean isAvailable() {
        return this.directory.isAvailable();
    }

    public void destroy() {
        this.directory.destroy();
        this.invoker.destroy();
    }

    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    public Result invoke(Invocation invocation) throws RpcException {
        Result result = null;
        String value = this.getUrl().getMethodParameter(invocation.getMethodName(), "mock", Boolean.FALSE.toString()).trim();
        if (value.length() == 0 || "false".equalsIgnoreCase(value)) {
            result = this.invoker.invoke(invocation);
        } else if (value.startsWith("force")) {
            if (logger.isWarnEnabled()) {
                logger.warn("force-mock: " + invocation.getMethodName() + " force-mock enabled , url : " + this.getUrl());
            }
            result = this.doMockInvoke(invocation, null);
        } else {
            try {
                result = this.invoker.invoke(invocation);
                if (result.getException() != null && result.getException() instanceof RpcException) {
                    RpcException rpcException = (RpcException)result.getException();
                    if (rpcException.isBiz()) {
                        throw rpcException;
                    }
                    result = this.doMockInvoke(invocation, rpcException);
                }
            }
            catch (RpcException e) {
                if (e.isBiz()) {
                    throw e;
                }
                if (logger.isWarnEnabled()) {
                    logger.warn("fail-mock: " + invocation.getMethodName() + " fail-mock enabled , url : " + this.getUrl(), (Throwable)e);
                }
                result = this.doMockInvoke(invocation, e);
            }
        }
        return result;
    }

    private Result doMockInvoke(Invocation invocation, RpcException e) {
        Result result = null;
        List<Invoker<T>> mockInvokers = this.selectMockInvoker(invocation);
        MockInvoker minvoker = CollectionUtils.isEmpty(mockInvokers) ? new MockInvoker(this.getUrl(), this.directory.getInterface()) : mockInvokers.get(0);
        try {
            result = minvoker.invoke(invocation);
        }
        catch (RpcException me) {
            if (me.isBiz()) {
                result = AsyncRpcResult.newDefaultAsyncResult((Throwable)me.getCause(), (Invocation)invocation);
            }
            throw new RpcException(me.getCode(), this.getMockExceptionMessage(e, me), me.getCause());
        }
        catch (Throwable me) {
            throw new RpcException(this.getMockExceptionMessage(e, me), me.getCause());
        }
        return result;
    }

    private String getMockExceptionMessage(Throwable t, Throwable mt) {
        String msg = "mock error : " + mt.getMessage();
        if (t != null) {
            msg = msg + ", invoke error is :" + StringUtils.toString((Throwable)t);
        }
        return msg;
    }

    private List<Invoker<T>> selectMockInvoker(Invocation invocation) {
        List<Invoker<T>> invokers;
        block3: {
            invokers = null;
            if (invocation instanceof RpcInvocation) {
                ((RpcInvocation)invocation).setAttachment("invocation.need.mock", Boolean.TRUE.toString());
                try {
                    invokers = this.directory.list(invocation);
                }
                catch (RpcException e) {
                    if (!logger.isInfoEnabled()) break block3;
                    logger.info("Exception when try to invoke mock. Get mock invokers error for service:" + this.getUrl().getServiceInterface() + ", method:" + invocation.getMethodName() + ", will construct a new mock with 'new MockInvoker()'.", (Throwable)e);
                }
            }
        }
        return invokers;
    }

    public String toString() {
        return "invoker :" + this.invoker + ",directory: " + this.directory;
    }
}

