/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.interceptor;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.ZoneDetector;
import org.apache.dubbo.rpc.cluster.interceptor.ClusterInterceptor;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

@Activate(value={"cluster:zone-aware"})
public class ZoneAwareClusterInterceptor
implements ClusterInterceptor {
    public static final String NAME = "zone-aware";

    @Override
    public void before(AbstractClusterInvoker<?> clusterInvoker, Invocation invocation) {
        RpcContext rpcContext = RpcContext.getContext();
        String zone = rpcContext.getAttachment("registry_zone");
        String force = rpcContext.getAttachment("registry_zone_force");
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(ZoneDetector.class);
        if (StringUtils.isEmpty((String)zone) && loader.hasExtension("default")) {
            ZoneDetector detector = (ZoneDetector)loader.getExtension("default");
            zone = detector.getZoneOfCurrentRequest(invocation);
            force = detector.isZoneForcingEnabled(invocation, zone);
        }
        if (StringUtils.isNotEmpty((String)zone)) {
            invocation.setAttachment("registry_zone", zone);
        }
        if (StringUtils.isNotEmpty((String)force)) {
            invocation.setAttachment("registry_zone_force", force);
        }
    }

    @Override
    public void after(AbstractClusterInvoker<?> clusterInvoker, Invocation invocation) {
    }
}

