/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.filter;

import org.apache.dubbo.auth.spi.Authenticator;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"consumer"}, order=-10000)
public class ConsumerSignFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        boolean shouldAuth = url.getParameter("auth", false);
        if (shouldAuth) {
            Authenticator authenticator = (Authenticator)ExtensionLoader.getExtensionLoader(Authenticator.class).getExtension(url.getParameter("authenticator", "accesskey"));
            authenticator.sign(invocation, url);
        }
        return invoker.invoke(invocation);
    }
}

