/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.config.Configs;

public class AbstractQueryWithResults<QueryType> {
    private final QueryType query;
    private final String description;
    private final List<Map<String, Object>> expectedResults;
    private final List<String> fieldsToTest;

    @JsonCreator
    public AbstractQueryWithResults(@JsonProperty(value="query") QueryType query, @JsonProperty(value="description") String description, @JsonProperty(value="expectedResults") List<Map<String, Object>> expectedResults, @JsonProperty(value="fieldsToTest") List<String> fieldsToTest) {
        this.query = query;
        this.description = description;
        this.expectedResults = expectedResults;
        this.fieldsToTest = (List)Configs.valueOrDefault(fieldsToTest, List.of());
    }

    @JsonProperty
    public QueryType getQuery() {
        return this.query;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public List<Map<String, Object>> getExpectedResults() {
        return this.expectedResults;
    }

    @JsonProperty
    public List<String> getFieldsToTest() {
        return this.fieldsToTest;
    }

    public String toString() {
        return "QueryWithResults{query=" + String.valueOf(this.query) + ", expectedResults=" + String.valueOf(this.expectedResults) + ", fieldsToTest=" + String.valueOf(this.fieldsToTest) + "}";
    }
}

