/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.testing.tools.EventSerializer;
import org.apache.druid.testing.tools.SyntheticStreamGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class WikipediaStreamEventStreamGenerator
extends SyntheticStreamGenerator {
    public static final String COL_UNIQUE_NAMESPACE = "namespace";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");

    public WikipediaStreamEventStreamGenerator(EventSerializer serializer, int eventsPerSeconds, long cyclePaddingMs) {
        super(serializer, eventsPerSeconds, cyclePaddingMs);
    }

    @Override
    List<Pair<String, Object>> newEvent(int i, DateTime timestamp) {
        ArrayList<Pair> event = new ArrayList<Pair>();
        event.add(Pair.of((Object)"timestamp", (Object)DATE_TIME_FORMATTER.print((ReadableInstant)timestamp)));
        event.add(Pair.of((Object)"page", (Object)"Gypsy Danger"));
        event.add(Pair.of((Object)"language", (Object)"en"));
        event.add(Pair.of((Object)"user", (Object)"nuclear"));
        event.add(Pair.of((Object)"unpatrolled", (Object)"true"));
        event.add(Pair.of((Object)"newPage", (Object)"true"));
        event.add(Pair.of((Object)"robot", (Object)"false"));
        event.add(Pair.of((Object)"anonymous", (Object)"false"));
        event.add(Pair.of((Object)COL_UNIQUE_NAMESPACE, (Object)("article " + IdUtils.getRandomId())));
        event.add(Pair.of((Object)"continent", (Object)"North America"));
        event.add(Pair.of((Object)"country", (Object)"United States"));
        event.add(Pair.of((Object)"region", (Object)"Bay Area"));
        event.add(Pair.of((Object)"city", (Object)"San Francisco"));
        event.add(Pair.of((Object)"added", (Object)i));
        event.add(Pair.of((Object)"deleted", (Object)0));
        event.add(Pair.of((Object)"delta", (Object)i));
        return Collections.unmodifiableList(event);
    }
}

