/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import com.amazonaws.util.AwsHostNameUtils;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.druid.testing.tools.ITRetryUtil;
import org.apache.druid.testing.tools.StreamEventWriter;

public class KinesisEventWriter
implements StreamEventWriter {
    private final KinesisProducer kinesisProducer;

    public KinesisEventWriter(String endpoint, boolean aggregate) throws Exception {
        String pathToConfigFile = System.getProperty("override.config.path");
        Properties prop = new Properties();
        prop.load(new FileInputStream(pathToConfigFile));
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(prop.getProperty("druid_kinesis_accessKey"), prop.getProperty("druid_kinesis_secretKey")));
        KinesisProducerConfiguration kinesisProducerConfiguration = new KinesisProducerConfiguration().setCredentialsProvider((AWSCredentialsProvider)credentials).setRegion(AwsHostNameUtils.parseRegion((String)endpoint, null)).setRequestTimeout(600000L).setConnectTimeout(300000L).setRecordTtl(Long.MAX_VALUE).setMetricsLevel("none").setAggregationEnabled(aggregate);
        this.kinesisProducer = new KinesisProducer(kinesisProducerConfiguration);
    }

    @Override
    public boolean supportTransaction() {
        return false;
    }

    @Override
    public boolean isTransactionEnabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commitTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(String streamName, byte[] event) {
        this.kinesisProducer.addUserRecord(streamName, DigestUtils.sha1Hex((byte[])event), ByteBuffer.wrap(event));
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        this.kinesisProducer.flushSync();
        ITRetryUtil.retryUntil(() -> this.kinesisProducer.getOutstandingRecordsCount() == 0, true, 10000L, 30, "Waiting for all Kinesis writes to be flushed");
    }

    protected KinesisProducer getKinesisProducer() {
        return this.kinesisProducer;
    }
}

