/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.ServerManager;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class ServerManagerForQueryErrorTest
extends ServerManager {
    public static final String QUERY_RETRY_TEST_CONTEXT_KEY = "query-retry-test";
    public static final String QUERY_TIMEOUT_TEST_CONTEXT_KEY = "query-timeout-test";
    public static final String QUERY_CAPACITY_EXCEEDED_TEST_CONTEXT_KEY = "query-capacity-exceeded-test";
    public static final String QUERY_UNSUPPORTED_TEST_CONTEXT_KEY = "query-unsupported-test";
    public static final String RESOURCE_LIMIT_EXCEEDED_TEST_CONTEXT_KEY = "resource-limit-exceeded-test";
    public static final String QUERY_FAILURE_TEST_CONTEXT_KEY = "query-failure-test";
    private static final Logger LOG = new Logger(ServerManagerForQueryErrorTest.class);
    private static final int MAX_NUM_FALSE_MISSING_SEGMENTS_REPORTS = 3;
    private final ConcurrentHashMap<String, Set<SegmentDescriptor>> queryToIgnoredSegments = new ConcurrentHashMap();

    @Inject
    public ServerManagerForQueryErrorTest(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, QueryProcessingPool queryProcessingPool, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, ServerConfig serverConfig) {
        super(conglomerate, emitter, queryProcessingPool, cachePopulator, objectMapper, cache, cacheConfig, segmentManager, serverConfig);
    }

    protected <T> QueryRunner<T> buildQueryRunnerForSegment(Query<T> query, SegmentDescriptor descriptor, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline, Function<SegmentReference, SegmentReference> segmentMapFn, AtomicLong cpuTimeAccumulator, Optional<byte[]> cacheKeyPrefix) {
        QueryContext queryContext = query.context();
        if (queryContext.getBoolean(QUERY_RETRY_TEST_CONTEXT_KEY, false)) {
            MutableBoolean isIgnoreSegment = new MutableBoolean(false);
            this.queryToIgnoredSegments.compute(query.getMostSpecificId(), (queryId, ignoredSegments) -> {
                if (ignoredSegments == null) {
                    ignoredSegments = new HashSet<SegmentDescriptor>();
                }
                if (ignoredSegments.size() < 3) {
                    ignoredSegments.add(descriptor);
                    isIgnoreSegment.setTrue();
                }
                return ignoredSegments;
            });
            if (isIgnoreSegment.isTrue()) {
                LOG.info("Pretending I don't have segment [%s]", new Object[]{descriptor});
                return new ReportTimelineMissingSegmentQueryRunner(descriptor);
            }
        } else {
            if (queryContext.getBoolean(QUERY_TIMEOUT_TEST_CONTEXT_KEY, false)) {
                return (queryPlus, responseContext) -> new Sequence<T>(){

                    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                        throw new QueryTimeoutException("query timeout test");
                    }

                    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                        throw new QueryTimeoutException("query timeout test");
                    }
                };
            }
            if (queryContext.getBoolean(QUERY_CAPACITY_EXCEEDED_TEST_CONTEXT_KEY, false)) {
                return (queryPlus, responseContext) -> new Sequence<T>(){

                    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                        throw QueryCapacityExceededException.withErrorMessageAndResolvedHost((String)"query capacity exceeded test");
                    }

                    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                        throw QueryCapacityExceededException.withErrorMessageAndResolvedHost((String)"query capacity exceeded test");
                    }
                };
            }
            if (queryContext.getBoolean(QUERY_UNSUPPORTED_TEST_CONTEXT_KEY, false)) {
                return (queryPlus, responseContext) -> new Sequence<T>(){

                    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                        throw new QueryUnsupportedException("query unsupported test");
                    }

                    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                        throw new QueryUnsupportedException("query unsupported test");
                    }
                };
            }
            if (queryContext.getBoolean(RESOURCE_LIMIT_EXCEEDED_TEST_CONTEXT_KEY, false)) {
                return (queryPlus, responseContext) -> new Sequence<T>(){

                    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                        throw new ResourceLimitExceededException("resource limit exceeded test");
                    }

                    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                        throw new ResourceLimitExceededException("resource limit exceeded test");
                    }
                };
            }
            if (queryContext.getBoolean(QUERY_FAILURE_TEST_CONTEXT_KEY, false)) {
                return (queryPlus, responseContext) -> new Sequence<T>(){

                    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                        throw new RuntimeException("query failure test");
                    }

                    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                        throw new RuntimeException("query failure test");
                    }
                };
            }
        }
        return super.buildQueryRunnerForSegment(query, descriptor, factory, toolChest, timeline, segmentMapFn, cpuTimeAccumulator, cacheKeyPrefix);
    }
}

