/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.cluster.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.cluster.ClusterTestingTaskConfig;

public class FaultyTaskLockbox
extends GlobalTaskLockbox {
    private static final Logger log = new Logger(FaultyTaskLockbox.class);
    private final ObjectMapper mapper;

    @Inject
    public FaultyTaskLockbox(TaskStorage taskStorage, IndexerMetadataStorageCoordinator metadataStorageCoordinator, ObjectMapper mapper) {
        super(taskStorage, metadataStorageCoordinator);
        this.mapper = mapper;
        log.info("Initializing FaultyTaskLockbox.", new Object[0]);
    }

    protected void cleanupPendingSegments(Task task) {
        ClusterTestingTaskConfig testingConfig = this.getTestingConfig(task);
        if (testingConfig.getMetadataConfig().isCleanupPendingSegments()) {
            super.cleanupPendingSegments(task);
        } else {
            log.info("Skipping cleanup of pending segments for task[%s] since it has testing config[%s].", new Object[]{task.getId(), testingConfig});
        }
    }

    private ClusterTestingTaskConfig getTestingConfig(Task task) {
        try {
            return ClusterTestingTaskConfig.forTask(task, this.mapper);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while reading testing config for task[%s] with context[%s]. Using default config with no faults.", new Object[]{task.getId(), task.getContext()});
            return ClusterTestingTaskConfig.DEFAULT;
        }
    }
}

