/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing;

import java.io.StringWriter;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.druid.testing.DruidCommand;
import org.apache.druid.testing.MountedDir;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class DruidContainer
extends GenericContainer<DruidContainer> {
    private static final String COMMON_PROPERTIES_PATH = "/tmp/druid_conf_common.runtime.properties";
    private static final String SERVICE_PROPERTIES_PATH = "/tmp/druid_conf_runtime.properties";
    private final Properties commonProperties = new Properties();
    private final Properties serviceProperties = new Properties();

    public DruidContainer(DruidCommand command, String imageName) {
        this(command, DockerImageName.parse((String)imageName));
    }

    public DruidContainer(DruidCommand command, DockerImageName imageName) {
        super(imageName);
        this.setCommand(command.getName());
        this.withEnv("DRUID_CONFIG_COMMON", COMMON_PROPERTIES_PATH);
        this.withEnv("DRUID_CONFIG_" + command.getName(), SERVICE_PROPERTIES_PATH);
        this.withEnv("JAVA_OPTS", command.getJavaOpts());
        Integer[] exposedPorts = command.getExposedPorts();
        this.withExposedPorts(exposedPorts);
        this.serviceProperties.putAll(command.getDefaultProperties());
        int servicePort = exposedPorts[0];
        this.serviceProperties.setProperty("druid.plaintextPort", String.valueOf(servicePort));
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/status/health").forPort(servicePort));
        List portBindings = Stream.of(exposedPorts).map(port -> port + ":" + port).collect(Collectors.toList());
        this.setPortBindings(portBindings);
    }

    public DruidContainer withFileSystemBind(MountedDir mountedDir) {
        return (DruidContainer)this.withFileSystemBind(mountedDir.hostFile().getAbsolutePath(), mountedDir.containerFile().getAbsolutePath(), BindMode.READ_WRITE);
    }

    public DruidContainer withCommonProperty(String key, String value) {
        this.commonProperties.setProperty(key, value);
        return this;
    }

    public DruidContainer withServiceProperty(String key, String value) {
        this.serviceProperties.setProperty(key, value);
        return this;
    }

    protected void containerIsCreated(String containerId) {
        this.copyFileToContainer(Transferable.of((String)DruidContainer.toString(this.commonProperties), (int)511), COMMON_PROPERTIES_PATH);
        this.copyFileToContainer(Transferable.of((String)DruidContainer.toString(this.serviceProperties), (int)511), SERVICE_PROPERTIES_PATH);
    }

    private static String toString(Properties properties) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, "Druid Runtime Properties");
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not serialize Druid runtime properties", e);
            }
        }
        writer.close();
        return string;
    }

    public static class Image {
        public static final DockerImageName APACHE_31 = DockerImageName.parse((String)"apache/druid:31.0.2");
        public static final DockerImageName APACHE_32 = DockerImageName.parse((String)"apache/druid:32.0.1");
        public static final DockerImageName APACHE_33 = DockerImageName.parse((String)"apache/druid:33.0.0");
    }
}

