/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.ObjectAggregateCombiner;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramBufferAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogramVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

@JsonTypeName(value="fixedBucketsHistogram")
public class FixedBucketsHistogramAggregatorFactory
extends AggregatorFactory {
    private static int DEFAULT_NUM_BUCKETS = 10;
    private final String name;
    private final String fieldName;
    private double lowerLimit;
    private double upperLimit;
    private int numBuckets;
    private FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode;
    private boolean finalizeAsBase64Binary;

    @JsonCreator
    public FixedBucketsHistogramAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="numBuckets") @Nullable Integer numBuckets, @JsonProperty(value="lowerLimit") double lowerLimit, @JsonProperty(value="upperLimit") double upperLimit, @JsonProperty(value="outlierHandlingMode") FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode, @JsonProperty(value="finalizeAsBase64Binary") @Nullable Boolean finalizeAsBase64Binary) {
        this.name = name;
        this.fieldName = fieldName;
        this.numBuckets = numBuckets == null ? DEFAULT_NUM_BUCKETS : numBuckets;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.outlierHandlingMode = outlierHandlingMode;
        this.finalizeAsBase64Binary = finalizeAsBase64Binary == null ? false : finalizeAsBase64Binary;
    }

    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new FixedBucketsHistogramAggregator((BaseObjectColumnValueSelector)metricFactory.makeColumnValueSelector(this.fieldName), this.lowerLimit, this.upperLimit, this.numBuckets, this.outlierHandlingMode);
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new FixedBucketsHistogramBufferAggregator((BaseObjectColumnValueSelector)metricFactory.makeColumnValueSelector(this.fieldName), this.lowerLimit, this.upperLimit, this.numBuckets, this.outlierHandlingMode);
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(this.fieldName);
        if (null == capabilities) {
            throw new IAE("could not find the column type for column %s", new Object[]{this.fieldName});
        }
        if (capabilities.isNumeric()) {
            return new FixedBucketsHistogramVectorAggregator(columnSelectorFactory.makeValueSelector(this.fieldName), this.lowerLimit, this.upperLimit, this.numBuckets, this.outlierHandlingMode);
        }
        throw new IAE("cannot vectorize fixed bucket histogram aggregation for type %s", new Object[]{capabilities.asTypeString()});
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        ColumnCapabilities capabilities = columnInspector.getColumnCapabilities(this.fieldName);
        return capabilities != null && capabilities.isNumeric();
    }

    public Comparator getComparator() {
        return FixedBucketsHistogramAggregator.COMPARATOR;
    }

    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs == null) {
            if (rhs == null) {
                return null;
            }
            return rhs;
        }
        ((FixedBucketsHistogram)lhs).combineHistogram((FixedBucketsHistogram)rhs);
        return lhs;
    }

    public AggregateCombiner makeAggregateCombiner() {
        return new ObjectAggregateCombiner(){
            private final FixedBucketsHistogram combined;
            {
                this.combined = new FixedBucketsHistogram(FixedBucketsHistogramAggregatorFactory.this.lowerLimit, FixedBucketsHistogramAggregatorFactory.this.upperLimit, FixedBucketsHistogramAggregatorFactory.this.numBuckets, FixedBucketsHistogramAggregatorFactory.this.outlierHandlingMode);
            }

            public void reset(ColumnValueSelector selector) {
                this.combined.reset();
                this.fold(selector);
            }

            public void fold(ColumnValueSelector selector) {
                FixedBucketsHistogram other = (FixedBucketsHistogram)selector.getObject();
                this.combined.combineHistogram(other);
            }

            public FixedBucketsHistogram getObject() {
                return this.combined;
            }

            public Class<FixedBucketsHistogram> classOfObject() {
                return FixedBucketsHistogram.class;
            }
        };
    }

    public AggregatorFactory getCombiningFactory() {
        return new FixedBucketsHistogramAggregatorFactory(this.name, this.name, this.numBuckets, this.lowerLimit, this.upperLimit, this.outlierHandlingMode, this.finalizeAsBase64Binary);
    }

    public AggregatorFactory getMergingFactory(AggregatorFactory other) {
        return new FixedBucketsHistogramAggregatorFactory(this.name, this.name, this.numBuckets, this.lowerLimit, this.upperLimit, this.outlierHandlingMode, this.finalizeAsBase64Binary);
    }

    public Object deserialize(Object object) {
        if (object instanceof String) {
            byte[] bytes = StringUtils.decodeBase64((byte[])StringUtils.toUtf8((String)((String)object)));
            FixedBucketsHistogram fbh = FixedBucketsHistogram.fromBytes(bytes);
            return fbh;
        }
        return object;
    }

    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (this.finalizeAsBase64Binary) {
            return object;
        }
        return object.toString();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public ColumnType getIntermediateType() {
        return FixedBucketsHistogramAggregator.TYPE;
    }

    public ColumnType getResultType() {
        return this.finalizeAsBase64Binary ? FixedBucketsHistogramAggregator.TYPE : ColumnType.STRING;
    }

    public int getMaxIntermediateSize() {
        return 2 + FixedBucketsHistogram.getFullStorageSize(this.numBuckets);
    }

    public AggregatorFactory withName(String newName) {
        return new FixedBucketsHistogramAggregatorFactory(newName, this.getFieldName(), this.getNumBuckets(), this.getLowerLimit(), this.getUpperLimit(), this.getOutlierHandlingMode(), this.isFinalizeAsBase64Binary());
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(51).appendString(this.fieldName).appendInt(this.outlierHandlingMode.ordinal()).appendInt(this.numBuckets).appendDouble(this.lowerLimit).appendDouble(this.upperLimit).appendBoolean(this.finalizeAsBase64Binary);
        return builder.build();
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public double getLowerLimit() {
        return this.lowerLimit;
    }

    @JsonProperty
    public double getUpperLimit() {
        return this.upperLimit;
    }

    @JsonProperty
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @JsonProperty
    public FixedBucketsHistogram.OutlierHandlingMode getOutlierHandlingMode() {
        return this.outlierHandlingMode;
    }

    @JsonProperty
    public boolean isFinalizeAsBase64Binary() {
        return this.finalizeAsBase64Binary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FixedBucketsHistogramAggregatorFactory that = (FixedBucketsHistogramAggregatorFactory)((Object)o);
        return Double.compare(that.getLowerLimit(), this.getLowerLimit()) == 0 && Double.compare(that.getUpperLimit(), this.getUpperLimit()) == 0 && this.getNumBuckets() == that.getNumBuckets() && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFieldName(), that.getFieldName()) && this.getOutlierHandlingMode() == that.getOutlierHandlingMode() && this.isFinalizeAsBase64Binary() == that.isFinalizeAsBase64Binary();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getFieldName(), this.getLowerLimit(), this.getUpperLimit(), this.getNumBuckets(), this.getOutlierHandlingMode(), this.isFinalizeAsBase64Binary()});
    }

    public String toString() {
        return "FixedBucketsHistogramAggregatorFactory{name='" + this.name + "', fieldName='" + this.fieldName + "', lowerLimit=" + this.lowerLimit + ", upperLimit=" + this.upperLimit + ", numBuckets=" + this.numBuckets + ", outlierHandlingMode=" + String.valueOf((Object)this.outlierHandlingMode) + ", finalizeAsBase64Binary=" + this.finalizeAsBase64Binary + "}";
    }
}

