/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.druid.concurrent.Threads;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;

public class CacheNotifier {
    private static final EmittingLogger LOG = new EmittingLogger(CacheNotifier.class);
    private final ExecutorService exec;
    private final String callerName;
    private final BlockingQueue<byte[]> updates = new LinkedBlockingQueue<byte[]>();
    private final Consumer<byte[]> sender;

    public CacheNotifier(String callerName, Consumer<byte[]> sender) {
        this.callerName = callerName;
        this.sender = sender;
        this.exec = Execs.singleThreaded((String)(StringUtils.format((String)"%s-notifierThread-", (Object[])new Object[]{StringUtils.encodeForFormat((String)callerName)}) + "%d"));
    }

    public void start() {
        LOG.info("Starting Catalog sync", new Object[0]);
        this.exec.submit(() -> {
            while (!Thread.interrupted()) {
                try {
                    this.sender.accept(this.updates.take());
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Throwable t) {
                    LOG.makeAlert(t, this.callerName + ": Error occured while handling updates.", new Object[0]).emit();
                }
            }
        });
    }

    public void send(byte[] update) {
        this.updates.add(update);
    }

    @VisibleForTesting
    public void stopGracefully() {
        try {
            while (!this.updates.isEmpty()) {
                Threads.sleepFor((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stop();
    }

    public void stop() {
        if (!this.updates.isEmpty()) {
            LOG.warn("Shutting down Catalog sync with %d unsent notifications", new Object[]{this.updates.size()});
        }
        this.exec.shutdownNow();
        LOG.info("Catalog sync stopped", new Object[0]);
    }
}

