/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class DataSourceOptimizerStats {
    private final String base;
    private final long hitcount;
    private final long totalcount;
    private final long optimizerCost;
    private final Map<Set<String>, AtomicLong> missFields;
    private final Map<String, Long> derivativesHitCount;

    public DataSourceOptimizerStats(String base, long hitcount, long totalcount, long optimizerCost, Map<Set<String>, AtomicLong> missFields, Map<String, Long> derivativesHitCount) {
        this.base = base;
        this.hitcount = hitcount;
        this.totalcount = totalcount;
        this.optimizerCost = optimizerCost;
        this.missFields = missFields;
        this.derivativesHitCount = derivativesHitCount;
    }

    public Map<Set<String>, AtomicLong> getMissFields() {
        return this.missFields;
    }

    public String getBase() {
        return this.base;
    }

    public long getHitcount() {
        return this.hitcount;
    }

    public long getTotalcount() {
        return this.totalcount;
    }

    public double getOptimizerCost() {
        if (this.totalcount == 0L) {
            return 0.0;
        }
        return (double)this.optimizerCost / (double)this.totalcount;
    }

    public double getHitRate() {
        if (this.totalcount == 0L) {
            return 0.0;
        }
        return (double)this.hitcount / (double)this.totalcount;
    }

    public Map<String, Long> getDerivativesHitCount() {
        return this.derivativesHitCount;
    }
}

