/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.materializedview;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;

public class DerivativeDataSource
implements Comparable<DerivativeDataSource> {
    private final String name;
    private final String baseDataSource;
    private final Set<String> columns;
    private final long avgSizeBasedGranularity;

    public DerivativeDataSource(String name, String baseDataSource, Set<String> columns, long size) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.baseDataSource = (String)Preconditions.checkNotNull((Object)baseDataSource, (Object)"baseDataSource");
        this.columns = (Set)Preconditions.checkNotNull(columns, (Object)"columns");
        this.avgSizeBasedGranularity = size;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseDataSource() {
        return this.baseDataSource;
    }

    public Set<String> getColumns() {
        return this.columns;
    }

    public long getAvgSizeBasedGranularity() {
        return this.avgSizeBasedGranularity;
    }

    @Override
    public int compareTo(DerivativeDataSource o) {
        if (this.avgSizeBasedGranularity > o.getAvgSizeBasedGranularity()) {
            return 1;
        }
        if (this.avgSizeBasedGranularity == o.getAvgSizeBasedGranularity()) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DerivativeDataSource)) {
            return false;
        }
        DerivativeDataSource that = (DerivativeDataSource)o;
        return this.name.equals(that.getName()) && this.baseDataSource.equals(that.getBaseDataSource()) && this.columns.equals(that.getColumns());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.baseDataSource, this.columns);
    }
}

