/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.materializedview;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.HadoopIOConfig;
import org.apache.druid.indexer.HadoopIngestionSpec;
import org.apache.druid.indexer.HadoopTuningConfig;
import org.apache.druid.indexer.granularity.ArbitraryGranularitySpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.hadoop.DatasourceIngestionSpec;
import org.apache.druid.indexing.common.task.HadoopIndexTask;
import org.apache.druid.indexing.materializedview.MaterializedViewSupervisor;
import org.apache.druid.indexing.materializedview.MaterializedViewTaskConfig;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.realtime.ChatHandlerProvider;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class MaterializedViewSupervisorSpec
implements SupervisorSpec {
    private static final String TASK_PREFIX = "index_materialized_view";
    private static final String SUPERVISOR_TYPE = "materialized_view";
    private final String baseDataSource;
    private final DimensionsSpec dimensionsSpec;
    private final AggregatorFactory[] aggregators;
    private final HadoopTuningConfig tuningConfig;
    private final String dataSourceName;
    private final String hadoopCoordinates;
    private final List<String> hadoopDependencyCoordinates;
    private final String classpathPrefix;
    private final Map<String, Object> context;
    private final Set<String> metrics;
    private final Set<String> dimensions;
    private final ObjectMapper objectMapper;
    private final MetadataSupervisorManager metadataSupervisorManager;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final TaskMaster taskMaster;
    private final TaskStorage taskStorage;
    private final MaterializedViewTaskConfig config;
    private final AuthorizerMapper authorizerMapper;
    private final ChatHandlerProvider chatHandlerProvider;
    private final SupervisorStateManagerConfig supervisorStateManagerConfig;
    private final boolean suspended;

    public MaterializedViewSupervisorSpec(@JsonProperty(value="baseDataSource") String baseDataSource, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="tuningConfig") HadoopTuningConfig tuningConfig, @JsonProperty(value="dataSource") String dataSourceName, @JsonProperty(value="hadoopCoordinates") String hadoopCoordinates, @JsonProperty(value="hadoopDependencyCoordinates") List<String> hadoopDependencyCoordinates, @JsonProperty(value="classpathPrefix") String classpathPrefix, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="suspended") Boolean suspended, @JacksonInject ObjectMapper objectMapper, @JacksonInject TaskMaster taskMaster, @JacksonInject TaskStorage taskStorage, @JacksonInject MetadataSupervisorManager metadataSupervisorManager, @JacksonInject IndexerMetadataStorageCoordinator metadataStorageCoordinator, @JacksonInject MaterializedViewTaskConfig config, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject SupervisorStateManagerConfig supervisorStateManagerConfig) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)baseDataSource) ? 1 : 0) != 0, (Object)"baseDataSource cannot be null or empty. Please provide a baseDataSource.");
        this.baseDataSource = baseDataSource;
        this.dimensionsSpec = (DimensionsSpec)Preconditions.checkNotNull((Object)dimensionsSpec, (Object)"dimensionsSpec cannot be null. Please provide a dimensionsSpec");
        this.aggregators = (AggregatorFactory[])Preconditions.checkNotNull((Object)aggregators, (Object)"metricsSpec cannot be null. Please provide a metricsSpec");
        this.tuningConfig = (HadoopTuningConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig cannot be null. Please provide tuningConfig");
        this.dataSourceName = dataSourceName == null ? StringUtils.format((String)"%s-%s", (Object[])new Object[]{baseDataSource, DigestUtils.sha1Hex((String)dimensionsSpec.toString()).substring(0, 8)}) : dataSourceName;
        this.hadoopCoordinates = hadoopCoordinates;
        this.hadoopDependencyCoordinates = hadoopDependencyCoordinates;
        this.classpathPrefix = classpathPrefix;
        this.context = context == null ? new HashMap() : context;
        this.objectMapper = objectMapper;
        this.taskMaster = taskMaster;
        this.taskStorage = taskStorage;
        this.metadataSupervisorManager = metadataSupervisorManager;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = chatHandlerProvider;
        this.config = config;
        this.supervisorStateManagerConfig = supervisorStateManagerConfig;
        this.suspended = suspended != null ? suspended : false;
        this.metrics = new HashSet<String>();
        for (AggregatorFactory aggregatorFactory : aggregators) {
            this.metrics.add(aggregatorFactory.getName());
        }
        this.dimensions = new HashSet<String>();
        for (DimensionSchema schema : dimensionsSpec.getDimensions()) {
            this.dimensions.add(schema.getName());
        }
    }

    public HadoopIndexTask createTask(Interval interval, String version, List<DataSegment> segments) {
        String taskId = StringUtils.format((String)"%s_%s_%s", (Object[])new Object[]{TASK_PREFIX, this.dataSourceName, DateTimes.nowUtc()});
        HashMap<String, String> parseSpec = new HashMap<String, String>();
        parseSpec.put("format", "timeAndDims");
        parseSpec.put("dimensionsSpec", (String)this.dimensionsSpec);
        HashMap<String, Object> parser = new HashMap<String, Object>();
        parser.put("type", "map");
        parser.put("parseSpec", parseSpec);
        HadoopTuningConfig tuningConfigForTask = new HadoopTuningConfig(this.tuningConfig.getWorkingPath(), version, this.tuningConfig.getPartitionsSpec(), this.tuningConfig.getShardSpecs(), this.tuningConfig.getIndexSpec(), this.tuningConfig.getIndexSpecForIntermediatePersists(), this.tuningConfig.getAppendableIndexSpec(), Integer.valueOf(this.tuningConfig.getMaxRowsInMemory()), Long.valueOf(this.tuningConfig.getMaxBytesInMemory()), this.tuningConfig.isLeaveIntermediate(), this.tuningConfig.isCleanupOnFailure(), this.tuningConfig.isOverwriteFiles(), this.tuningConfig.isIgnoreInvalidRows(), this.tuningConfig.getJobProperties(), this.tuningConfig.isCombineText(), Boolean.valueOf(this.tuningConfig.getUseCombiner()), Integer.valueOf(this.tuningConfig.getMaxRowsInMemory()), Integer.valueOf(this.tuningConfig.getNumBackgroundPersistThreads()), this.tuningConfig.isForceExtendableShardSpecs(), true, this.tuningConfig.getUserAllowedHadoopPrefix(), Boolean.valueOf(this.tuningConfig.isLogParseExceptions()), Integer.valueOf(this.tuningConfig.getMaxParseExceptions()), Boolean.valueOf(this.tuningConfig.isUseYarnRMJobStatusFallback()), Long.valueOf(this.tuningConfig.getAwaitSegmentAvailabilityTimeoutMillis()), Integer.valueOf(1));
        ArbitraryGranularitySpec granularitySpec = new ArbitraryGranularitySpec(Granularities.NONE, (List)ImmutableList.of((Object)interval));
        DataSchema dataSchema = DataSchema.builder().withDataSource(this.dataSourceName).withParserMap(parser).withAggregators(this.aggregators).withGranularity((GranularitySpec)granularitySpec).withObjectMapper(this.objectMapper).build();
        DatasourceIngestionSpec datasourceIngestionSpec = new DatasourceIngestionSpec(this.baseDataSource, null, (List)ImmutableList.of((Object)interval), segments, null, null, null, false, null);
        HashMap<String, String> inputSpec = new HashMap<String, String>();
        inputSpec.put("type", "dataSource");
        inputSpec.put("ingestionSpec", (String)datasourceIngestionSpec);
        HadoopIOConfig hadoopIOConfig = new HadoopIOConfig(inputSpec, null, null);
        HadoopIngestionSpec spec = new HadoopIngestionSpec(dataSchema, hadoopIOConfig, tuningConfigForTask);
        HadoopIndexTask task = new HadoopIndexTask(taskId, spec, this.hadoopCoordinates, this.hadoopDependencyCoordinates, this.classpathPrefix, this.objectMapper, this.context, this.authorizerMapper, this.chatHandlerProvider);
        return task;
    }

    public Set<String> getDimensions() {
        return this.dimensions;
    }

    public Set<String> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="baseDataSource")
    public String getBaseDataSource() {
        return this.baseDataSource;
    }

    @JsonProperty(value="dimensionsSpec")
    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getMetricsSpec() {
        return this.aggregators;
    }

    @JsonProperty(value="tuningConfig")
    public HadoopTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty(value="dataSource")
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @JsonProperty(value="hadoopCoordinates")
    public String getHadoopCoordinates() {
        return this.hadoopCoordinates;
    }

    @JsonProperty(value="hadoopDependencyCoordinates")
    public List<String> getSadoopDependencyCoordinates() {
        return this.hadoopDependencyCoordinates;
    }

    @JsonProperty(value="classpathPrefix")
    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    @JsonProperty(value="context")
    public Map<String, Object> getContext() {
        return this.context;
    }

    @JsonProperty(value="suspended")
    public boolean isSuspended() {
        return this.suspended;
    }

    @JsonProperty(value="type")
    public String getType() {
        return SUPERVISOR_TYPE;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.getBaseDataSource();
    }

    public String getId() {
        return StringUtils.format((String)"MaterializedViewSupervisor-%s", (Object[])new Object[]{this.dataSourceName});
    }

    public Supervisor createSupervisor() {
        return new MaterializedViewSupervisor(this.taskMaster, this.taskStorage, this.metadataSupervisorManager, this.metadataStorageCoordinator, this.config, this);
    }

    public List<String> getDataSources() {
        return ImmutableList.of((Object)this.dataSourceName);
    }

    public SupervisorSpec createSuspendedSpec() {
        return new MaterializedViewSupervisorSpec(this.baseDataSource, this.dimensionsSpec, this.aggregators, this.tuningConfig, this.dataSourceName, this.hadoopCoordinates, this.hadoopDependencyCoordinates, this.classpathPrefix, this.context, true, this.objectMapper, this.taskMaster, this.taskStorage, this.metadataSupervisorManager, this.metadataStorageCoordinator, this.config, this.authorizerMapper, this.chatHandlerProvider, this.supervisorStateManagerConfig);
    }

    public SupervisorSpec createRunningSpec() {
        return new MaterializedViewSupervisorSpec(this.baseDataSource, this.dimensionsSpec, this.aggregators, this.tuningConfig, this.dataSourceName, this.hadoopCoordinates, this.hadoopDependencyCoordinates, this.classpathPrefix, this.context, false, this.objectMapper, this.taskMaster, this.taskStorage, this.metadataSupervisorManager, this.metadataStorageCoordinator, this.config, this.authorizerMapper, this.chatHandlerProvider, this.supervisorStateManagerConfig);
    }

    public SupervisorStateManagerConfig getSupervisorStateManagerConfig() {
        return this.supervisorStateManagerConfig;
    }

    public String toString() {
        return "MaterializedViewSupervisorSpec{baseDataSource=" + this.baseDataSource + ", dimensions=" + String.valueOf(this.dimensions) + ", metrics=" + String.valueOf(this.metrics) + "}";
    }
}

