/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ProtocolStringList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.druid.grpc.proto.QueryOuterClass;
import org.apache.druid.grpc.server.ProtobufTransformer;
import org.apache.druid.grpc.server.ProtobufWriter;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.SqlPlanningException;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlParameter;
import org.joda.time.format.ISODateTimeFormat;

public class QueryDriver {
    private static final Logger log = new Logger(QueryDriver.class);
    private static final String TIME_FIELD_KEY = "timeFieldKey";
    private final ObjectMapper jsonMapper;
    private final SqlStatementFactory sqlStatementFactory;
    private final Map<String, Object> defaultContext;
    private final QueryLifecycleFactory queryLifecycleFactory;

    public QueryDriver(ObjectMapper jsonMapper, SqlStatementFactory sqlStatementFactory, Map<String, Object> defaultContext, QueryLifecycleFactory queryLifecycleFactory) {
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"jsonMapper");
        this.sqlStatementFactory = (SqlStatementFactory)Preconditions.checkNotNull((Object)sqlStatementFactory, (Object)"sqlStatementFactory");
        this.defaultContext = defaultContext;
        this.queryLifecycleFactory = queryLifecycleFactory;
    }

    public QueryOuterClass.QueryResponse submitQuery(QueryOuterClass.QueryRequest request, AuthenticationResult authResult) {
        if (request.getQueryType() == QueryOuterClass.QueryType.NATIVE) {
            return this.runNativeQuery(request, authResult);
        }
        return this.runSqlQuery(request, authResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryOuterClass.QueryResponse runNativeQuery(QueryOuterClass.QueryRequest request, AuthenticationResult authResult) {
        Query query;
        try {
            query = (Query)this.jsonMapper.readValue(request.getQuery(), Query.class);
        }
        catch (JsonProcessingException e) {
            return QueryOuterClass.QueryResponse.newBuilder().setQueryId("").setStatus(QueryOuterClass.QueryStatus.REQUEST_ERROR).setErrorMessage(e.getMessage()).build();
        }
        if (Strings.isNullOrEmpty((String)query.getId())) {
            query = query.withId(UUID.randomUUID().toString());
        }
        QueryLifecycle queryLifecycle = this.queryLifecycleFactory.factorize();
        String currThreadName = Thread.currentThread().getName();
        try {
            queryLifecycle.initialize(query);
            AuthorizationResult authorizationResult = queryLifecycle.authorize(authResult);
            if (!authorizationResult.allowAccessWithNoRestriction()) {
                throw new ForbiddenException("Unauthorized");
            }
            QueryResponse queryResponse = queryLifecycle.execute();
            QueryToolChest queryToolChest = queryLifecycle.getToolChest();
            Sequence sequence = queryToolChest.resultsAsArrays(query, queryResponse.getResults());
            RowSignature rowSignature = queryToolChest.resultArraySignature(query);
            Thread.currentThread().setName(StringUtils.format((String)"grpc-native[%s]", (Object[])new Object[]{query.getId()}));
            ByteString results = this.encodeNativeResults(request, (Sequence<Object[]>)sequence, rowSignature);
            QueryOuterClass.QueryResponse queryResponse2 = QueryOuterClass.QueryResponse.newBuilder().setQueryId(query.getId()).setStatus(QueryOuterClass.QueryStatus.OK).setData(results).clearErrorMessage().addAllColumns(this.encodeNativeColumns(rowSignature, (List<String>)request.getSkipColumnsList())).build();
            return queryResponse2;
        }
        catch (IOException | RuntimeException e) {
            QueryOuterClass.QueryResponse queryResponse = QueryOuterClass.QueryResponse.newBuilder().setQueryId(query.getId()).setStatus(QueryOuterClass.QueryStatus.RUNTIME_ERROR).setErrorMessage(e.getMessage()).build();
            return queryResponse;
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryOuterClass.QueryResponse runSqlQuery(QueryOuterClass.QueryRequest request, AuthenticationResult authResult) {
        SqlQueryPlus queryPlus;
        try {
            queryPlus = this.translateQuery(request, authResult);
        }
        catch (RuntimeException e) {
            return QueryOuterClass.QueryResponse.newBuilder().setQueryId("").setStatus(QueryOuterClass.QueryStatus.REQUEST_ERROR).setErrorMessage(e.getMessage()).build();
        }
        DirectStatement stmt = this.sqlStatementFactory.directStatement(queryPlus);
        String currThreadName = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(StringUtils.format((String)"grpc-sql[%s]", (Object[])new Object[]{stmt.sqlQueryId()}));
            DirectStatement.ResultSet thePlan = stmt.plan();
            SqlRowTransformer rowTransformer = thePlan.createRowTransformer();
            ByteString results = this.encodeSqlResults(request, (Sequence<Object[]>)thePlan.run().getResults(), rowTransformer);
            stmt.reporter().succeeded((long)results.size());
            stmt.close();
            QueryOuterClass.QueryResponse queryResponse = QueryOuterClass.QueryResponse.newBuilder().setQueryId(stmt.sqlQueryId()).setStatus(QueryOuterClass.QueryStatus.OK).setData(results).clearErrorMessage().addAllColumns(this.encodeSqlColumns(rowTransformer)).build();
            return queryResponse;
        }
        catch (ForbiddenException e) {
            stmt.reporter().failed((Throwable)e);
            stmt.close();
            throw e;
        }
        catch (RequestError e) {
            stmt.reporter().failed((Throwable)((Object)e));
            stmt.close();
            QueryOuterClass.QueryResponse queryResponse = QueryOuterClass.QueryResponse.newBuilder().setQueryId(stmt.sqlQueryId()).setStatus(QueryOuterClass.QueryStatus.REQUEST_ERROR).setErrorMessage(e.getMessage()).build();
            return queryResponse;
        }
        catch (SqlPlanningException e) {
            stmt.reporter().failed((Throwable)e);
            stmt.close();
            QueryOuterClass.QueryResponse queryResponse = QueryOuterClass.QueryResponse.newBuilder().setQueryId(stmt.sqlQueryId()).setStatus(QueryOuterClass.QueryStatus.INVALID_SQL).setErrorMessage(e.getMessage()).build();
            return queryResponse;
        }
        catch (IOException | RuntimeException e) {
            stmt.reporter().failed((Throwable)e);
            stmt.close();
            QueryOuterClass.QueryResponse queryResponse = QueryOuterClass.QueryResponse.newBuilder().setQueryId(stmt.sqlQueryId()).setStatus(QueryOuterClass.QueryStatus.RUNTIME_ERROR).setErrorMessage(e.getMessage()).build();
            return queryResponse;
        }
        catch (AssertionError e) {
            stmt.reporter().failed((Throwable)((Object)e));
            stmt.close();
            QueryOuterClass.QueryResponse queryResponse = QueryOuterClass.QueryResponse.newBuilder().setQueryId(stmt.sqlQueryId()).setStatus(QueryOuterClass.QueryStatus.RUNTIME_ERROR).setErrorMessage(((Throwable)((Object)e)).getMessage()).build();
            return queryResponse;
        }
        finally {
            Thread.currentThread().setName(currThreadName);
        }
    }

    private SqlQueryPlus translateQuery(QueryOuterClass.QueryRequest request, AuthenticationResult authResult) {
        return SqlQueryPlus.builder().sql(request.getQuery()).systemDefaultContext(this.defaultContext).queryContext(this.translateContext(request)).sqlParameters(this.translateParameters(request)).auth(authResult).build();
    }

    private Map<String, Object> translateContext(QueryOuterClass.QueryRequest request) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (request.getContextCount() > 0) {
            for (Map.Entry<String, String> entry : request.getContextMap().entrySet()) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return builder.build();
    }

    private List<SqlParameter> translateParameters(QueryOuterClass.QueryRequest request) {
        if (request.getParametersCount() == 0) {
            return null;
        }
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        for (QueryOuterClass.QueryParameter value : request.getParametersList()) {
            params.add(this.translateParameter(value));
        }
        return params;
    }

    private SqlParameter translateParameter(QueryOuterClass.QueryParameter value) {
        switch (value.getValueCase()) {
            case DOUBLEVALUE: {
                return new SqlParameter(SqlType.DOUBLE, (Object)value.getDoubleValue());
            }
            case LONGVALUE: {
                return new SqlParameter(SqlType.BIGINT, (Object)value.getLongValue());
            }
            case STRINGVALUE: {
                return new SqlParameter(SqlType.VARCHAR, (Object)value.getStringValue());
            }
            case NULLVALUE: 
            case VALUE_NOT_SET: {
                return null;
            }
        }
        throw new RequestError("Invalid parameter type: " + value.getValueCase().name(), new Object[0]);
    }

    private Iterable<? extends QueryOuterClass.ColumnSchema> encodeSqlColumns(SqlRowTransformer rowTransformer) {
        RelDataType rowType = rowTransformer.getRowType();
        RowSignature signature = RowSignatures.fromRelDataType((List)rowType.getFieldNames(), (RelDataType)rowType);
        ArrayList<QueryOuterClass.ColumnSchema> cols = new ArrayList<QueryOuterClass.ColumnSchema>();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            QueryOuterClass.ColumnSchema col = QueryOuterClass.ColumnSchema.newBuilder().setName(signature.getColumnName(i)).setSqlType(((RelDataTypeField)rowType.getFieldList().get(i)).getType().getSqlTypeName().getName()).setDruidType(this.convertDruidType(signature.getColumnType(i))).build();
            cols.add(col);
        }
        return cols;
    }

    private Iterable<? extends QueryOuterClass.ColumnSchema> encodeNativeColumns(RowSignature rowSignature, List<String> skipColumns) {
        ArrayList<QueryOuterClass.ColumnSchema> cols = new ArrayList<QueryOuterClass.ColumnSchema>();
        for (int i = 0; i < rowSignature.getColumnNames().size(); ++i) {
            if (skipColumns.contains(rowSignature.getColumnName(i))) continue;
            QueryOuterClass.ColumnSchema col = QueryOuterClass.ColumnSchema.newBuilder().setName(rowSignature.getColumnName(i)).setDruidType(this.convertDruidType(rowSignature.getColumnType(i))).build();
            cols.add(col);
        }
        return cols;
    }

    private QueryOuterClass.DruidType convertDruidType(Optional<ColumnType> colType) {
        if (!colType.isPresent()) {
            return QueryOuterClass.DruidType.UNKNOWN_TYPE;
        }
        ColumnType druidType = colType.get();
        if (druidType == ColumnType.STRING) {
            return QueryOuterClass.DruidType.STRING;
        }
        if (druidType == ColumnType.STRING_ARRAY) {
            return QueryOuterClass.DruidType.STRING_ARRAY;
        }
        if (druidType == ColumnType.LONG) {
            return QueryOuterClass.DruidType.LONG;
        }
        if (druidType == ColumnType.LONG_ARRAY) {
            return QueryOuterClass.DruidType.LONG_ARRAY;
        }
        if (druidType == ColumnType.FLOAT) {
            return QueryOuterClass.DruidType.FLOAT;
        }
        if (druidType == ColumnType.FLOAT_ARRAY) {
            return QueryOuterClass.DruidType.FLOAT_ARRAY;
        }
        if (druidType == ColumnType.DOUBLE) {
            return QueryOuterClass.DruidType.DOUBLE;
        }
        if (druidType == ColumnType.DOUBLE_ARRAY) {
            return QueryOuterClass.DruidType.DOUBLE_ARRAY;
        }
        if (druidType == ColumnType.UNKNOWN_COMPLEX) {
            return QueryOuterClass.DruidType.COMPLEX;
        }
        return QueryOuterClass.DruidType.UNKNOWN_TYPE;
    }

    private ByteString encodeSqlResults(QueryOuterClass.QueryRequest request, Sequence<Object[]> result, SqlRowTransformer rowTransformer) throws IOException {
        GrpcSqlResultFormatWriter writer;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        switch (request.getResultFormat()) {
            case CSV: {
                writer = new GrpcSqlResultFormatWriter(ResultFormat.CSV.createFormatter((OutputStream)out, this.jsonMapper), rowTransformer);
                break;
            }
            case JSON_ARRAY: {
                writer = new GrpcSqlResultFormatWriter(ResultFormat.ARRAY.createFormatter((OutputStream)out, this.jsonMapper), rowTransformer);
                break;
            }
            case JSON_ARRAY_LINES: {
                writer = new GrpcSqlResultFormatWriter(ResultFormat.ARRAYLINES.createFormatter((OutputStream)out, this.jsonMapper), rowTransformer);
                break;
            }
            case PROTOBUF_INLINE: {
                writer = new GrpcSqlResultFormatWriter(new ProtobufWriter(out, this.getProtobufClass(request)), rowTransformer);
                break;
            }
            default: {
                throw new RequestError("Unsupported query result format: " + request.getResultFormat().name(), new Object[0]);
            }
        }
        GrpcResultsAccumulator accumulator = new GrpcResultsAccumulator(writer);
        accumulator.push(result);
        return ByteString.copyFrom((byte[])out.toByteArray());
    }

    private ByteString encodeNativeResults(QueryOuterClass.QueryRequest request, Sequence<Object[]> result, RowSignature rowSignature) throws IOException {
        GrpcNativeResultFormatWriter writer;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String timeFieldName = request.getContextMap().getOrDefault(TIME_FIELD_KEY, "time");
        ProtocolStringList skipColumns = request.getSkipColumnsList();
        ProtocolStringList timeColumns = request.getTimeColumnsList();
        switch (request.getResultFormat()) {
            case CSV: {
                writer = new GrpcNativeResultFormatWriter(ResultFormat.CSV.createFormatter((OutputStream)out, this.jsonMapper), rowSignature, timeFieldName, (List<String>)timeColumns, (List<String>)skipColumns);
                break;
            }
            case JSON_ARRAY: {
                writer = new GrpcNativeResultFormatWriter(ResultFormat.ARRAY.createFormatter((OutputStream)out, this.jsonMapper), rowSignature, timeFieldName, (List<String>)timeColumns, (List<String>)skipColumns);
                break;
            }
            case JSON_ARRAY_LINES: {
                writer = new GrpcNativeResultFormatWriter(ResultFormat.ARRAYLINES.createFormatter((OutputStream)out, this.jsonMapper), rowSignature, timeFieldName, (List<String>)timeColumns, (List<String>)skipColumns);
                break;
            }
            case PROTOBUF_INLINE: {
                writer = new GrpcNativeResultFormatWriter(new ProtobufWriter(out, this.getProtobufClass(request)), rowSignature, timeFieldName, (List<String>)timeColumns, (List<String>)skipColumns);
                break;
            }
            default: {
                throw new RequestError("Unsupported query result format: " + request.getResultFormat(), new Object[0]);
            }
        }
        GrpcResultsAccumulator accumulator = new GrpcResultsAccumulator(writer);
        accumulator.push(result);
        return ByteString.copyFrom((byte[])out.toByteArray());
    }

    private Class<GeneratedMessageV3> getProtobufClass(QueryOuterClass.QueryRequest request) {
        try {
            return Class.forName(request.getProtobufMessageName());
        }
        catch (ClassNotFoundException e) {
            throw new RequestError("The Protobuf class [%s] is not known. Is your protobuf jar on the class path?", request.getProtobufMessageName());
        }
        catch (ClassCastException e) {
            throw new RequestError("The class [%s] is not a Protobuf", request.getProtobufMessageName());
        }
    }

    protected static class RequestError
    extends RE {
        public RequestError(String msg, Object ... args) {
            super(msg, args);
        }
    }

    public static class GrpcSqlResultFormatWriter
    implements GrpcResultWriter {
        protected final ResultFormat.Writer formatWriter;
        protected final SqlRowTransformer rowTransformer;

        public GrpcSqlResultFormatWriter(ResultFormat.Writer formatWriter, SqlRowTransformer rowTransformer) {
            this.formatWriter = formatWriter;
            this.rowTransformer = rowTransformer;
        }

        @Override
        public void start() throws IOException {
            this.formatWriter.writeResponseStart();
        }

        @Override
        public void writeRow(Object[] row) throws IOException {
            this.formatWriter.writeRowStart();
            for (int i = 0; i < this.rowTransformer.getFieldList().size(); ++i) {
                Object value = this.formatWriter instanceof ProtobufWriter ? ProtobufTransformer.transform(this.rowTransformer, row, i) : this.rowTransformer.transform(row, i);
                this.formatWriter.writeRowField((String)this.rowTransformer.getFieldList().get(i), value);
            }
            this.formatWriter.writeRowEnd();
        }

        @Override
        public void close() throws IOException {
            this.formatWriter.writeResponseEnd();
            this.formatWriter.close();
        }
    }

    public static class GrpcResultsAccumulator
    implements Accumulator<Void, Object[]> {
        private final GrpcResultWriter writer;

        public GrpcResultsAccumulator(GrpcResultWriter writer) {
            this.writer = writer;
        }

        public void push(Sequence<Object[]> results) throws IOException {
            this.writer.start();
            try {
                results.accumulate(null, (Accumulator)this);
            }
            catch (ResponseError e) {
                throw (IOException)e.getCause();
            }
            this.writer.close();
        }

        public Void accumulate(Void accumulated, Object[] in) {
            try {
                this.writer.writeRow(in);
            }
            catch (IOException e) {
                throw new ResponseError(e);
            }
            return null;
        }
    }

    public static interface GrpcResultWriter {
        public void start() throws IOException;

        public void writeRow(Object[] var1) throws IOException;

        public void close() throws IOException;
    }

    public static class GrpcNativeResultFormatWriter
    implements GrpcResultWriter {
        protected final ResultFormat.Writer formatWriter;
        protected final RowSignature rowSignature;
        private final String timeFieldName;
        private final List<String> timeColumns;
        private final List<String> skipColumns;

        public GrpcNativeResultFormatWriter(ResultFormat.Writer formatWriter, RowSignature rowSignature, String timeFieldName, List<String> timeColumns, List<String> skipColumns) {
            this.formatWriter = formatWriter;
            this.rowSignature = rowSignature;
            this.timeFieldName = timeFieldName;
            this.timeColumns = timeColumns;
            this.skipColumns = skipColumns;
        }

        @Override
        public void start() throws IOException {
            this.formatWriter.writeResponseStart();
        }

        @Override
        public void writeRow(Object[] row) throws IOException {
            this.formatWriter.writeRowStart();
            for (int i = 0; i < this.rowSignature.getColumnNames().size(); ++i) {
                String columnName = this.rowSignature.getColumnName(i);
                if (this.skipColumns.contains(columnName)) {
                    log.debug("Skipping column [%s] from the result.", new Object[]{columnName});
                    continue;
                }
                boolean isDruidTimeColumn = columnName.equals("__time");
                boolean convertTime = this.timeColumns.contains(this.rowSignature.getColumnName(i));
                Object value = this.formatWriter instanceof ProtobufWriter ? ProtobufTransformer.transform(this.rowSignature, row, i, convertTime) : (convertTime ? ISODateTimeFormat.dateTime().print(((Long)row[i]).longValue()) : row[i]);
                String outputColumnName = isDruidTimeColumn ? this.timeFieldName : this.rowSignature.getColumnName(i);
                this.formatWriter.writeRowField(outputColumnName, value);
            }
            this.formatWriter.writeRowEnd();
        }

        @Override
        public void close() throws IOException {
            this.formatWriter.writeResponseEnd();
            this.formatWriter.close();
        }
    }

    private static class ResponseError
    extends RuntimeException {
        public ResponseError(IOException e) {
            super(e);
        }
    }
}

