/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.grpc.client;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class GrpcResponseHandler<T extends AbstractMessageLite> {
    private final T message;

    private GrpcResponseHandler(Class<T> clazz) {
        this.message = this.get(clazz);
    }

    public static <T extends AbstractMessageLite> GrpcResponseHandler<T> of(Class<T> clazz) {
        return new GrpcResponseHandler<T>(clazz);
    }

    public List<T> get(ByteString byteString) {
        return this.get(new ByteArrayInputStream(byteString.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> get(InputStream inputStream) {
        try {
            ArrayList<AbstractMessageLite> data = new ArrayList<AbstractMessageLite>();
            try {
                MessageLite messageLite;
                while ((messageLite = (MessageLite)this.message.getDefaultInstanceForType().getParserForType().parseDelimitedFrom(inputStream)) != null) {
                    data.add((AbstractMessageLite)messageLite);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ArrayList<AbstractMessageLite> arrayList = data;
            return arrayList;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private T get(Class<T> clazz) {
        try {
            Method method = clazz.getMethod("getDefaultInstance", new Class[0]);
            return (T)((AbstractMessageLite)method.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

