/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis.util;

import java.net.URI;
import org.apache.druid.redis.shaded.redis.clients.jedis.HostAndPort;
import org.apache.druid.redis.shaded.redis.clients.jedis.RedisProtocol;

public final class JedisURIHelper {
    private static final String REDIS = "redis";
    private static final String REDISS = "rediss";

    private JedisURIHelper() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static HostAndPort getHostAndPort(URI uri) {
        return new HostAndPort(uri.getHost(), uri.getPort());
    }

    public static String getUser(URI uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String user = userInfo.split(":", 2)[0];
            if (user.isEmpty()) {
                user = null;
            }
            return user;
        }
        return null;
    }

    public static String getPassword(URI uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            return userInfo.split(":", 2)[1];
        }
        return null;
    }

    public static int getDBIndex(URI uri) {
        String[] pathSplit = uri.getPath().split("/", 2);
        if (pathSplit.length > 1) {
            String dbIndexStr = pathSplit[1];
            if (dbIndexStr.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(dbIndexStr);
        }
        return 0;
    }

    public static RedisProtocol getRedisProtocol(URI uri) {
        String[] pairs;
        if (uri.getQuery() == null) {
            return null;
        }
        for (String pair : pairs = uri.getQuery().split("&")) {
            int idx = pair.indexOf("=");
            if (!"protocol".equals(pair.substring(0, idx))) continue;
            String ver = pair.substring(idx + 1);
            for (RedisProtocol proto : RedisProtocol.values()) {
                if (!proto.version().equals(ver)) continue;
                return proto;
            }
            throw new IllegalArgumentException("Unknown protocol " + ver);
        }
        return null;
    }

    public static boolean isValid(URI uri) {
        return !JedisURIHelper.isEmpty(uri.getScheme()) && !JedisURIHelper.isEmpty(uri.getHost()) && uri.getPort() != -1;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isRedisScheme(URI uri) {
        return REDIS.equals(uri.getScheme());
    }

    public static boolean isRedisSSLScheme(URI uri) {
        return REDISS.equals(uri.getScheme());
    }
}

