/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.redis.shaded.redis.clients.jedis.providers;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.druid.redis.shaded.redis.clients.jedis.CommandArguments;
import org.apache.druid.redis.shaded.redis.clients.jedis.Connection;
import org.apache.druid.redis.shaded.redis.clients.jedis.ConnectionPool;
import org.apache.druid.redis.shaded.redis.clients.jedis.MultiClusterClientConfig;
import org.apache.druid.redis.shaded.redis.clients.jedis.exceptions.JedisConnectionException;
import org.apache.druid.redis.shaded.redis.clients.jedis.exceptions.JedisValidationException;
import org.apache.druid.redis.shaded.redis.clients.jedis.providers.ConnectionProvider;
import org.apache.druid.redis.shaded.redis.clients.jedis.util.Pool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiClusterPooledConnectionProvider
implements ConnectionProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Integer, Cluster> multiClusterMap = new ConcurrentHashMap<Integer, Cluster>();
    private volatile Integer activeMultiClusterIndex = 1;
    private volatile boolean lastClusterCircuitBreakerForcedOpen = false;
    private Consumer<String> clusterFailoverPostProcessor;
    private List<Class<? extends Throwable>> fallbackExceptionList;

    public MultiClusterPooledConnectionProvider(MultiClusterClientConfig multiClusterClientConfig) {
        MultiClusterClientConfig.ClusterConfig[] clusterConfigs;
        if (multiClusterClientConfig == null) {
            throw new JedisValidationException("MultiClusterClientConfig must not be NULL for MultiClusterPooledConnectionProvider");
        }
        RetryConfig.Builder retryConfigBuilder = RetryConfig.custom();
        retryConfigBuilder.maxAttempts(multiClusterClientConfig.getRetryMaxAttempts());
        retryConfigBuilder.intervalFunction(IntervalFunction.ofExponentialBackoff((Duration)multiClusterClientConfig.getRetryWaitDuration(), (double)multiClusterClientConfig.getRetryWaitDurationExponentialBackoffMultiplier()));
        retryConfigBuilder.failAfterMaxAttempts(false);
        retryConfigBuilder.retryExceptions((Class[])multiClusterClientConfig.getRetryIncludedExceptionList().stream().toArray(Class[]::new));
        List<Class> retryIgnoreExceptionList = multiClusterClientConfig.getRetryIgnoreExceptionList();
        if (retryIgnoreExceptionList != null) {
            retryConfigBuilder.ignoreExceptions((Class[])retryIgnoreExceptionList.stream().toArray(Class[]::new));
        }
        RetryConfig retryConfig = retryConfigBuilder.build();
        CircuitBreakerConfig.Builder circuitBreakerConfigBuilder = CircuitBreakerConfig.custom();
        circuitBreakerConfigBuilder.failureRateThreshold(multiClusterClientConfig.getCircuitBreakerFailureRateThreshold());
        circuitBreakerConfigBuilder.slowCallRateThreshold(multiClusterClientConfig.getCircuitBreakerSlowCallRateThreshold());
        circuitBreakerConfigBuilder.slowCallDurationThreshold(multiClusterClientConfig.getCircuitBreakerSlowCallDurationThreshold());
        circuitBreakerConfigBuilder.minimumNumberOfCalls(multiClusterClientConfig.getCircuitBreakerSlidingWindowMinCalls());
        circuitBreakerConfigBuilder.slidingWindowType(multiClusterClientConfig.getCircuitBreakerSlidingWindowType());
        circuitBreakerConfigBuilder.slidingWindowSize(multiClusterClientConfig.getCircuitBreakerSlidingWindowSize());
        circuitBreakerConfigBuilder.recordExceptions((Class[])multiClusterClientConfig.getCircuitBreakerIncludedExceptionList().stream().toArray(Class[]::new));
        circuitBreakerConfigBuilder.automaticTransitionFromOpenToHalfOpenEnabled(false);
        List<Class> circuitBreakerIgnoreExceptionList = multiClusterClientConfig.getCircuitBreakerIgnoreExceptionList();
        if (circuitBreakerIgnoreExceptionList != null) {
            circuitBreakerConfigBuilder.ignoreExceptions((Class[])circuitBreakerIgnoreExceptionList.stream().toArray(Class[]::new));
        }
        CircuitBreakerConfig circuitBreakerConfig = circuitBreakerConfigBuilder.build();
        for (MultiClusterClientConfig.ClusterConfig config : clusterConfigs = multiClusterClientConfig.getClusterConfigs()) {
            String clusterId = "cluster:" + config.getPriority() + ":" + config.getHostAndPort();
            Retry retry = RetryRegistry.of((RetryConfig)retryConfig).retry(clusterId);
            Retry.EventPublisher retryPublisher = retry.getEventPublisher();
            retryPublisher.onRetry(event -> this.log.warn(String.valueOf(event)));
            retryPublisher.onError(event -> this.log.error(String.valueOf(event)));
            CircuitBreaker circuitBreaker = CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig).circuitBreaker(clusterId);
            CircuitBreaker.EventPublisher circuitBreakerEventPublisher = circuitBreaker.getEventPublisher();
            circuitBreakerEventPublisher.onCallNotPermitted(event -> this.log.error(String.valueOf(event)));
            circuitBreakerEventPublisher.onError(event -> this.log.error(String.valueOf(event)));
            circuitBreakerEventPublisher.onFailureRateExceeded(event -> this.log.error(String.valueOf(event)));
            circuitBreakerEventPublisher.onSlowCallRateExceeded(event -> this.log.error(String.valueOf(event)));
            circuitBreakerEventPublisher.onStateTransition(event -> this.log.warn(String.valueOf(event)));
            this.multiClusterMap.put(config.getPriority(), new Cluster(new ConnectionPool(config.getHostAndPort(), config.getJedisClientConfig()), retry, circuitBreaker));
        }
        this.fallbackExceptionList = multiClusterClientConfig.getFallbackExceptionList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementActiveMultiClusterIndex() {
        Integer n = this.activeMultiClusterIndex;
        synchronized (n) {
            String originalClusterName = this.getClusterCircuitBreaker().getName();
            if (this.activeMultiClusterIndex + 1 > this.multiClusterMap.size()) {
                this.lastClusterCircuitBreakerForcedOpen = true;
                throw new JedisConnectionException("Cluster/database endpoint could not failover since the MultiClusterClientConfig was not provided with an additional cluster/database endpoint according to its prioritized sequence. If applicable, consider failing back OR restarting with an available cluster/database endpoint");
            }
            Integer n2 = this.activeMultiClusterIndex;
            Integer n3 = this.activeMultiClusterIndex = Integer.valueOf(this.activeMultiClusterIndex + 1);
            CircuitBreaker circuitBreaker = this.getClusterCircuitBreaker();
            if (CircuitBreaker.State.FORCED_OPEN.equals((Object)circuitBreaker.getState())) {
                this.incrementActiveMultiClusterIndex();
            } else {
                this.log.warn("Cluster/database endpoint successfully updated from '{}' to '{}'", (Object)originalClusterName, (Object)circuitBreaker.getName());
            }
        }
        return this.activeMultiClusterIndex;
    }

    public void validateTargetConnection(int multiClusterIndex) {
        CircuitBreaker circuitBreaker = this.getClusterCircuitBreaker(multiClusterIndex);
        CircuitBreaker.State originalState = circuitBreaker.getState();
        try {
            circuitBreaker.transitionToClosedState();
            try (Connection targetConnection = this.getConnection(multiClusterIndex);){
                targetConnection.ping();
            }
        }
        catch (Exception e) {
            if (CircuitBreaker.State.FORCED_OPEN.equals((Object)originalState)) {
                circuitBreaker.transitionToForcedOpenState();
            }
            throw new JedisValidationException(circuitBreaker.getName() + " failed to connect. Please check configuration and try again.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setActiveMultiClusterIndex(int multiClusterIndex) {
        Integer n = this.activeMultiClusterIndex;
        synchronized (n) {
            if (this.activeMultiClusterIndex == multiClusterIndex && !CircuitBreaker.State.FORCED_OPEN.equals((Object)this.getClusterCircuitBreaker(multiClusterIndex).getState())) {
                return;
            }
            if (multiClusterIndex < 1 || multiClusterIndex > this.multiClusterMap.size()) {
                throw new JedisValidationException("MultiClusterIndex: " + multiClusterIndex + " is not within the configured range. Please choose an index between 1 and " + this.multiClusterMap.size());
            }
            this.validateTargetConnection(multiClusterIndex);
            String originalClusterName = this.getClusterCircuitBreaker().getName();
            if (this.activeMultiClusterIndex == multiClusterIndex) {
                this.log.warn("Cluster/database endpoint '{}' successfully closed its circuit breaker", (Object)originalClusterName);
            } else {
                this.log.warn("Cluster/database endpoint successfully updated from '{}' to '{}'", (Object)originalClusterName, (Object)this.getClusterCircuitBreaker(multiClusterIndex).getName());
            }
            this.activeMultiClusterIndex = multiClusterIndex;
            this.lastClusterCircuitBreakerForcedOpen = false;
        }
    }

    @Override
    public void close() {
        this.multiClusterMap.get(this.activeMultiClusterIndex).getConnectionPool().close();
    }

    @Override
    public Connection getConnection() {
        return this.multiClusterMap.get(this.activeMultiClusterIndex).getConnection();
    }

    public Connection getConnection(int multiClusterIndex) {
        return this.multiClusterMap.get(multiClusterIndex).getConnection();
    }

    @Override
    public Connection getConnection(CommandArguments args) {
        return this.multiClusterMap.get(this.activeMultiClusterIndex).getConnection();
    }

    public Map<?, Pool<Connection>> getConnectionMap() {
        ConnectionPool connectionPool = this.multiClusterMap.get(this.activeMultiClusterIndex).getConnectionPool();
        return Collections.singletonMap(connectionPool.getFactory(), connectionPool);
    }

    public Cluster getCluster() {
        return this.multiClusterMap.get(this.activeMultiClusterIndex);
    }

    public CircuitBreaker getClusterCircuitBreaker() {
        return this.multiClusterMap.get(this.activeMultiClusterIndex).getCircuitBreaker();
    }

    public CircuitBreaker getClusterCircuitBreaker(int multiClusterIndex) {
        return this.multiClusterMap.get(multiClusterIndex).getCircuitBreaker();
    }

    public boolean isLastClusterCircuitBreakerForcedOpen() {
        return this.lastClusterCircuitBreakerForcedOpen;
    }

    public void runClusterFailoverPostProcessor(Integer multiClusterIndex) {
        if (this.clusterFailoverPostProcessor != null) {
            this.clusterFailoverPostProcessor.accept(this.getClusterCircuitBreaker(multiClusterIndex).getName());
        }
    }

    public void setClusterFailoverPostProcessor(Consumer<String> clusterFailoverPostProcessor) {
        this.clusterFailoverPostProcessor = clusterFailoverPostProcessor;
    }

    public List<Class<? extends Throwable>> getFallbackExceptionList() {
        return this.fallbackExceptionList;
    }

    public static class Cluster {
        private final ConnectionPool connectionPool;
        private final Retry retry;
        private final CircuitBreaker circuitBreaker;

        public Cluster(ConnectionPool connectionPool, Retry retry, CircuitBreaker circuitBreaker) {
            this.connectionPool = connectionPool;
            this.retry = retry;
            this.circuitBreaker = circuitBreaker;
        }

        public Connection getConnection() {
            return this.connectionPool.getResource();
        }

        public ConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        public Retry getRetry() {
            return this.retry;
        }

        public CircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }
    }
}

