/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.cache.AbstractRedisCache;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.RedisCacheConfig;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.redis.shaded.redis.clients.jedis.Jedis;
import org.apache.druid.redis.shaded.redis.clients.jedis.JedisPool;

public class RedisStandaloneCache
extends AbstractRedisCache {
    private final JedisPool pool;

    RedisStandaloneCache(JedisPool pool, RedisCacheConfig config) {
        super(config);
        this.pool = pool;
    }

    @Override
    protected byte[] getFromRedis(byte[] key) {
        try (Jedis jedis = this.pool.getResource();){
            byte[] byArray = jedis.get(key);
            return byArray;
        }
    }

    @Override
    protected void putToRedis(byte[] key, byte[] value, RedisCacheConfig.DurationConfig expiration) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.psetex(key, expiration.getMilliseconds(), value);
        }
    }

    @Override
    protected Pair<Integer, Map<Cache.NamedKey, byte[]>> mgetFromRedis(Iterable<Cache.NamedKey> keys) {
        ArrayList namedKeys = Lists.newArrayList(keys);
        List byteKeys = Lists.transform((List)namedKeys, Cache.NamedKey::toByteArray);
        try (Jedis jedis = this.pool.getResource();){
            List<byte[]> byteValues = jedis.mget((byte[][])byteKeys.toArray((T[])new byte[0][]));
            HashMap<Cache.NamedKey, byte[]> results = new HashMap<Cache.NamedKey, byte[]>();
            for (int i = 0; i < byteValues.size(); ++i) {
                if (byteValues.get(i) == null) continue;
                results.put((Cache.NamedKey)namedKeys.get(i), byteValues.get(i));
            }
            Pair pair = new Pair((Object)namedKeys.size(), results);
            return pair;
        }
    }

    @Override
    protected void cleanup() {
        this.pool.close();
    }
}

