/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.RedisCacheConfig;
import org.apache.druid.client.cache.RedisClusterCache;
import org.apache.druid.client.cache.RedisStandaloneCache;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.redis.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.druid.redis.shaded.redis.clients.jedis.Connection;
import org.apache.druid.redis.shaded.redis.clients.jedis.ConnectionPoolConfig;
import org.apache.druid.redis.shaded.redis.clients.jedis.HostAndPort;
import org.apache.druid.redis.shaded.redis.clients.jedis.Jedis;
import org.apache.druid.redis.shaded.redis.clients.jedis.JedisCluster;
import org.apache.druid.redis.shaded.redis.clients.jedis.JedisPool;
import org.apache.druid.redis.shaded.redis.clients.jedis.JedisPoolConfig;

public class RedisCacheFactory {
    public static Cache create(RedisCacheConfig config) {
        if (config.getCluster() != null && StringUtils.isNotBlank((CharSequence)config.getCluster().getNodes())) {
            Set<HostAndPort> nodes = Arrays.stream(config.getCluster().getNodes().split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(hostAndPort -> {
                int port;
                int index = hostAndPort.indexOf(58);
                if (index <= 0 || index == hostAndPort.length()) {
                    throw new IAE("Invalid redis cluster configuration: %s", new Object[]{hostAndPort});
                }
                try {
                    port = Integer.parseInt(hostAndPort.substring(index + 1));
                }
                catch (NumberFormatException e) {
                    throw new IAE("Invalid port in %s", new Object[]{hostAndPort});
                }
                if (port <= 0 || port > 65535) {
                    throw new IAE("Invalid port in %s", new Object[]{hostAndPort});
                }
                return new HostAndPort(hostAndPort.substring(0, index), port);
            }).collect(Collectors.toSet());
            ConnectionPoolConfig poolConfig = new ConnectionPoolConfig();
            poolConfig.setMaxTotal(config.getMaxTotalConnections());
            poolConfig.setMaxIdle(config.getMaxIdleConnections());
            poolConfig.setMinIdle(config.getMinIdleConnections());
            JedisCluster cluster = config.getPassword() != null ? new JedisCluster(nodes, config.getTimeout().getMillisecondsAsInt(), config.getTimeout().getMillisecondsAsInt(), config.getCluster().getMaxRedirection(), config.getPassword().getPassword(), (GenericObjectPoolConfig<Connection>)poolConfig) : new JedisCluster(nodes, config.getTimeout().getMillisecondsAsInt(), config.getCluster().getMaxRedirection(), (GenericObjectPoolConfig<Connection>)poolConfig);
            return new RedisClusterCache(cluster, config);
        }
        if (StringUtils.isBlank((CharSequence)config.getHost())) {
            throw new IAE("Invalid redis configuration. no redis server or cluster configured.", new Object[0]);
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(config.getMaxTotalConnections());
        poolConfig.setMaxIdle(config.getMaxIdleConnections());
        poolConfig.setMinIdle(config.getMinIdleConnections());
        return new RedisStandaloneCache(new JedisPool((GenericObjectPoolConfig<Jedis>)poolConfig, config.getHost(), config.getPort(), config.getTimeout().getMillisecondsAsInt(), config.getPassword() == null ? null : config.getPassword().getPassword(), config.getDatabase(), null), config);
    }
}

