/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheStats;
import org.apache.druid.client.cache.RedisCacheConfig;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.redis.shaded.redis.clients.jedis.exceptions.JedisException;

public abstract class AbstractRedisCache
implements Cache {
    private static final Logger log = new Logger(AbstractRedisCache.class);
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);
    private final AtomicLong timeoutCount = new AtomicLong(0L);
    private final AtomicLong errorCount = new AtomicLong(0L);
    private final AtomicLong priorRequestCount = new AtomicLong(0L);
    private final AtomicLong totalRequestCount = new AtomicLong(0L);
    private RedisCacheConfig.DurationConfig expiration;

    protected AbstractRedisCache(RedisCacheConfig config) {
        this.expiration = config.getExpiration();
    }

    public byte[] get(Cache.NamedKey key) {
        this.totalRequestCount.incrementAndGet();
        try {
            byte[] bytes = this.getFromRedis(key.toByteArray());
            if (bytes == null) {
                this.missCount.incrementAndGet();
                return null;
            }
            this.hitCount.incrementAndGet();
            return bytes;
        }
        catch (JedisException e) {
            if (e.getMessage().contains("Read timed out")) {
                this.timeoutCount.incrementAndGet();
            } else {
                this.errorCount.incrementAndGet();
            }
            log.warn((Throwable)e, "Exception pulling item from cache", new Object[0]);
            return null;
        }
    }

    public void put(Cache.NamedKey key, byte[] value) {
        this.totalRequestCount.incrementAndGet();
        try {
            this.putToRedis(key.toByteArray(), value, this.expiration);
        }
        catch (JedisException e) {
            this.errorCount.incrementAndGet();
            log.warn((Throwable)e, "Exception pushing item to cache", new Object[0]);
        }
    }

    public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
        this.totalRequestCount.incrementAndGet();
        try {
            Pair<Integer, Map<Cache.NamedKey, byte[]>> results = this.mgetFromRedis(keys);
            this.hitCount.addAndGet(((Map)results.rhs).size());
            this.missCount.addAndGet((Integer)results.lhs - ((Map)results.rhs).size());
            return (Map)results.rhs;
        }
        catch (JedisException e) {
            if (e.getMessage().contains("Read timed out")) {
                this.timeoutCount.incrementAndGet();
            } else {
                this.errorCount.incrementAndGet();
            }
            log.warn((Throwable)e, "Exception pulling items from cache", new Object[0]);
            return Collections.emptyMap();
        }
    }

    public void close(String namespace) {
    }

    @LifecycleStop
    public void close() {
        this.cleanup();
    }

    public CacheStats getStats() {
        return new CacheStats(this.hitCount.get(), this.missCount.get(), 0L, 0L, 0L, this.timeoutCount.get(), this.errorCount.get());
    }

    public boolean isLocal() {
        return false;
    }

    public void doMonitor(ServiceEmitter emitter) {
        long priorCount = this.priorRequestCount.get();
        long totalCount = this.totalRequestCount.get();
        ServiceMetricEvent.Builder builder = ServiceMetricEvent.builder();
        emitter.emit((ServiceEventBuilder)builder.setMetric("query/cache/redis/total/requests", (Number)totalCount));
        emitter.emit((ServiceEventBuilder)builder.setMetric("query/cache/redis/delta/requests", (Number)(totalCount - priorCount)));
        if (!this.priorRequestCount.compareAndSet(priorCount, totalCount)) {
            log.error("Prior value changed while I was reporting! updating anyways", new Object[0]);
            this.priorRequestCount.set(totalCount);
        }
    }

    protected abstract byte[] getFromRedis(byte[] var1);

    protected abstract void putToRedis(byte[] var1, byte[] var2, RedisCacheConfig.DurationConfig var3);

    protected abstract Pair<Integer, Map<Cache.NamedKey, byte[]>> mgetFromRedis(Iterable<Cache.NamedKey> var1);

    protected abstract void cleanup();
}

