/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.HashMap;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.movingaverage.AveragerFactoryWrapper;
import org.apache.druid.query.movingaverage.DefaultMovingAverageQueryMetricsFactory;
import org.apache.druid.query.movingaverage.MovingAverageQuery;
import org.apache.druid.query.movingaverage.MovingAverageQueryMetrics;
import org.apache.druid.query.movingaverage.MovingAverageQueryMetricsFactory;
import org.apache.druid.query.movingaverage.MovingAverageQueryRunner;
import org.apache.druid.query.movingaverage.averagers.AveragerFactory;
import org.apache.druid.server.log.RequestLogger;

public class MovingAverageQueryToolChest
extends QueryToolChest<Row, MovingAverageQuery> {
    private final Provider<QuerySegmentWalker> walkerProvider;
    private final RequestLogger requestLogger;
    private final MovingAverageQueryMetricsFactory movingAverageQueryMetricsFactory;

    @Inject
    public MovingAverageQueryToolChest(@Named(value="movingAverage") Provider<QuerySegmentWalker> walkerProvider, @Named(value="movingAverage") RequestLogger requestLogger) {
        this.walkerProvider = walkerProvider;
        this.requestLogger = requestLogger;
        this.movingAverageQueryMetricsFactory = DefaultMovingAverageQueryMetricsFactory.instance();
    }

    public QueryRunner<Row> mergeResults(QueryRunner<Row> runner) {
        return new MovingAverageQueryRunner((QuerySegmentWalker)this.walkerProvider.get(), this.requestLogger);
    }

    public QueryMetrics<? super MovingAverageQuery> makeMetrics(MovingAverageQuery query) {
        MovingAverageQueryMetrics movingAverageQueryMetrics = this.movingAverageQueryMetricsFactory.makeMetrics();
        movingAverageQueryMetrics.query((Query)query);
        return movingAverageQueryMetrics;
    }

    public Function<Row, Row> makePostComputeManipulatorFn(final MovingAverageQuery query, final MetricManipulationFn fn) {
        return new Function<Row, Row>(){

            public Row apply(Row result) {
                Object aggVal;
                MapBasedRow mRow = (MapBasedRow)result;
                HashMap<String, Object> values = new HashMap<String, Object>(mRow.getEvent());
                for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
                    aggVal = values.get(aggregatorFactory.getName());
                    if (aggVal != null) {
                        values.put(aggregatorFactory.getName(), fn.manipulate(aggregatorFactory, aggVal));
                        continue;
                    }
                    values.put(aggregatorFactory.getName(), null);
                }
                for (AveragerFactory averagerFactory : query.getAveragerSpecs()) {
                    aggVal = values.get(averagerFactory.getName());
                    if (aggVal != null) {
                        values.put(averagerFactory.getName(), fn.manipulate(new AveragerFactoryWrapper(averagerFactory, averagerFactory.getName() + "_"), aggVal));
                        continue;
                    }
                    values.put(averagerFactory.getName(), null);
                }
                return new MapBasedRow(result.getTimestamp(), values);
            }
        };
    }

    public TypeReference<Row> getResultTypeReference() {
        return new TypeReference<Row>(){};
    }

    public Function<Row, Row> makePreComputeManipulatorFn(MovingAverageQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }
}

