/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.apache.druid.query.movingaverage.averagers.AveragerFactory;

public abstract class BaseAveragerFactory<R, F>
implements AveragerFactory<R, F> {
    protected String name;
    protected String fieldName;
    protected int numBuckets;
    protected int cycleSize;

    public BaseAveragerFactory(String name, int numBuckets, String fieldName, Integer cycleSize) {
        this.name = name;
        this.numBuckets = numBuckets;
        this.fieldName = fieldName;
        this.cycleSize = cycleSize != null ? cycleSize : 1;
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null averager name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null field name");
        Preconditions.checkArgument((this.cycleSize > 0 ? 1 : 0) != 0, (Object)"Cycle size must be greater than zero");
        Preconditions.checkArgument((numBuckets > 0 ? 1 : 0) != 0, (Object)"Bucket size must be greater than zero");
        Preconditions.checkArgument((this.cycleSize <= numBuckets ? 1 : 0) != 0, (Object)"Cycle size must be less than the bucket size");
        Preconditions.checkArgument((numBuckets % this.cycleSize == 0 ? 1 : 0) != 0, (Object)"cycleSize must devide numBuckets without a remainder");
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    @JsonProperty(value="buckets")
    public int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    @JsonProperty(value="cycleSize")
    public int getCycleSize() {
        return this.cycleSize;
    }

    @Override
    public List<String> getDependentFields() {
        return Collections.singletonList(this.fieldName);
    }

    @Override
    public F finalizeComputation(R val) {
        return (F)val;
    }
}

