/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.movingaverage.averagers;

import org.apache.druid.query.movingaverage.averagers.BaseAverager;

public class LongMaxAverager
extends BaseAverager<Number, Long> {
    public LongMaxAverager(int numBuckets, String name, String fieldName, int cycleSize) {
        super(Number.class, numBuckets, name, fieldName, cycleSize);
    }

    @Override
    protected Long computeResult() {
        long result = Long.MIN_VALUE;
        for (int i = 0; i < this.numBuckets; i += this.cycleSize) {
            if (((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets] == null) continue;
            result = Long.max(result, ((Number[])this.buckets)[(i + this.startFrom) % this.numBuckets].longValue());
        }
        ++this.startFrom;
        return result;
    }
}

