/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64;
import org.apache.druid.query.aggregation.exact.count.bitmap64.RoaringBitmap64Counter;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class Bitmap64ExactCountBuildBufferAggregator
implements BufferAggregator {
    private final BaseLongColumnValueSelector selector;
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<Bitmap64>> collectors = new IdentityHashMap();

    public Bitmap64ExactCountBuildBufferAggregator(BaseLongColumnValueSelector selector) {
        this.selector = selector;
    }

    public void init(ByteBuffer buf, int position) {
        this.createNewCollector(buf, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(ByteBuffer buf, int position) {
        int oldPosition = buf.position();
        try {
            buf.position(position);
            Bitmap64 bitmap64Counter = this.getOrCreateCollector(buf, position);
            if (!this.selector.isNull()) {
                bitmap64Counter.add(this.selector.getLong());
            }
        }
        finally {
            buf.position(oldPosition);
        }
    }

    public Object get(ByteBuffer buf, int position) {
        return this.getOrCreateCollector(buf, position);
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.createNewCollector(newBuffer, newPosition);
        Bitmap64 collector = (Bitmap64)this.collectors.get(oldBuffer).get(oldPosition);
        this.putCollectors(newBuffer, newPosition, collector);
        Int2ObjectMap<Bitmap64> collectorMap = this.collectors.get(oldBuffer);
        if (collectorMap != null) {
            collectorMap.remove(oldPosition);
            if (collectorMap.isEmpty()) {
                this.collectors.remove(oldBuffer);
            }
        }
    }

    private void putCollectors(ByteBuffer buffer, int position, Bitmap64 collector) {
        Int2ObjectMap map = this.collectors.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)collector);
    }

    private Bitmap64 getOrCreateCollector(ByteBuffer buf, int position) {
        Bitmap64 bitmap64Counter;
        Int2ObjectMap<Bitmap64> collectMap = this.collectors.get(buf);
        Bitmap64 bitmap64 = bitmap64Counter = collectMap != null ? (Bitmap64)collectMap.get(position) : null;
        if (bitmap64Counter != null) {
            return bitmap64Counter;
        }
        return this.createNewCollector(buf, position);
    }

    private Bitmap64 createNewCollector(ByteBuffer buf, int position) {
        buf.position(position);
        RoaringBitmap64Counter bitmap64Counter = new RoaringBitmap64Counter();
        Int2ObjectMap collectorMap = this.collectors.computeIfAbsent(buf, k -> new Int2ObjectOpenHashMap());
        collectorMap.put(position, (Object)bitmap64Counter);
        return bitmap64Counter;
    }
}

