/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64;
import org.apache.druid.query.aggregation.exact.count.bitmap64.ExposedByteArrayOutputStream;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RoaringBitmap64Counter
implements Bitmap64 {
    private static final Logger log = new Logger(RoaringBitmap64Counter.class);
    private final Roaring64NavigableMap bitmap;

    public RoaringBitmap64Counter() {
        this.bitmap = new Roaring64NavigableMap();
    }

    private RoaringBitmap64Counter(Roaring64NavigableMap bitmap) {
        this.bitmap = bitmap;
    }

    public static RoaringBitmap64Counter fromBytes(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(inputStream);
        return RoaringBitmap64Counter.fromDataInput(in);
    }

    public static RoaringBitmap64Counter fromDataInput(DataInput in) {
        try {
            Roaring64NavigableMap bitmap = new Roaring64NavigableMap();
            bitmap.deserialize(in);
            return new RoaringBitmap64Counter(bitmap);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to deserialize RoaringBitmap64Counter from data input", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(long value) {
        this.bitmap.addLong(value);
    }

    @Override
    public long getCardinality() {
        return this.bitmap.getLongCardinality();
    }

    @Override
    public Bitmap64 fold(Bitmap64 rhs) {
        if (rhs != null) {
            this.bitmap.or(((RoaringBitmap64Counter)rhs).bitmap);
        }
        return this;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        this.bitmap.runOptimize();
        try {
            ExposedByteArrayOutputStream out = new ExposedByteArrayOutputStream();
            this.bitmap.serialize((DataOutput)new DataOutputStream(out));
            return out.getBuffer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

