/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.exact.count.bitmap64;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.exact.count.bitmap64.Bitmap64;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="bitmap64ExactCount")
public class Bitmap64ExactCountPostAggregator
implements PostAggregator {
    private final String name;
    private final String fieldName;

    @JsonCreator
    public Bitmap64ExactCountPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this.name = name;
        this.fieldName = fieldName;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    public Comparator getComparator() {
        return ArithmeticPostAggregator.DEFAULT_COMPARATOR;
    }

    @JsonProperty
    public Object compute(Map<String, Object> combinedAggregators) {
        Object value = combinedAggregators.get(this.fieldName);
        return ((Bitmap64)value).getCardinality();
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Nullable
    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.LONG;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(53).appendString(this.fieldName).build();
    }

    public String toString() {
        return "Bitmap64ExactCountPostAggregator{name='" + this.name + "', field=" + this.fieldName + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bitmap64ExactCountPostAggregator that = (Bitmap64ExactCountPostAggregator)o;
        return this.name.equals(that.name) && this.fieldName.equals(that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName);
    }
}

