/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Provides;
import java.util.List;
import org.apache.druid.guice.Binders;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.cloudfiles.CloudFilesAccountConfig;
import org.apache.druid.storage.cloudfiles.CloudFilesDataSegmentPusher;
import org.apache.druid.storage.cloudfiles.CloudFilesDataSegmentPusherConfig;
import org.apache.druid.storage.cloudfiles.CloudFilesLoadSpec;
import org.jclouds.ContextBuilder;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.openstack.keystone.catalog.config.InternalUrlModule;
import org.jclouds.osgi.ProviderRegistry;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rackspace.cloudfiles.uk.CloudFilesUKProviderMetadata;
import org.jclouds.rackspace.cloudfiles.us.CloudFilesUSProviderMetadata;
import org.jclouds.rackspace.cloudfiles.v1.CloudFilesApi;

public class CloudFilesStorageDruidModule
implements DruidModule {
    private static final Logger log = new Logger(CloudFilesStorageDruidModule.class);
    public static final String SCHEME = "cloudfiles";

    public List<? extends Module> getJacksonModules() {
        log.info("Getting jackson modules...", new Object[0]);
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "CloudFiles-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{CloudFilesLoadSpec.class});
            }
        });
    }

    public void configure(Binder binder) {
        log.info("Configuring CloudFilesStorageDruidModule...", new Object[0]);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", CloudFilesDataSegmentPusherConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.cloudfiles", CloudFilesAccountConfig.class);
        Binders.dataSegmentPusherBinder((Binder)binder).addBinding((Object)SCHEME).to(CloudFilesDataSegmentPusher.class).in(LazySingleton.class);
        log.info("Configured CloudFilesStorageDruidModule.", new Object[0]);
    }

    @Provides
    @LazySingleton
    public CloudFilesApi getCloudFilesApi(CloudFilesAccountConfig config) {
        ImmutableSet modules;
        log.info("Building Cloud Files Api...", new Object[0]);
        if (config.getUseServiceNet()) {
            log.info("Configuring Cloud Files Api to use the internal service network...", new Object[0]);
            modules = ImmutableSet.of((Object)new SLF4JLoggingModule(), (Object)new InternalUrlModule());
        } else {
            log.info("Configuring Cloud Files Api to use the public network...", new Object[0]);
            modules = ImmutableSet.of((Object)new SLF4JLoggingModule());
        }
        ProviderRegistry.registerProvider((ProviderMetadata)CloudFilesUSProviderMetadata.builder().build());
        ProviderRegistry.registerProvider((ProviderMetadata)CloudFilesUKProviderMetadata.builder().build());
        ContextBuilder cb = ContextBuilder.newBuilder((String)config.getProvider()).credentials(config.getUserName(), config.getApiKey()).modules((Iterable)modules);
        CloudFilesApi cfa = (CloudFilesApi)cb.buildApi(CloudFilesApi.class);
        log.info("Cloud Files Api built.", new Object[0]);
        return cfa;
    }
}

