/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.cloudfiles;

import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.File;
import org.apache.druid.storage.cloudfiles.CloudFilesUtils;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;

public class CloudFilesObject {
    private Payload payload;
    private String path;
    private final String region;
    private final String container;

    public CloudFilesObject(String basePath, File file, String region, String container) {
        this(region, container);
        ByteSource byteSource = Files.asByteSource((File)file);
        this.payload = Payloads.newByteSourcePayload((ByteSource)byteSource);
        this.path = CloudFilesUtils.buildCloudFilesPath(basePath, file.getName());
    }

    public CloudFilesObject(Payload payload, String region, String container, String path) {
        this(region, container, path);
        this.payload = payload;
    }

    private CloudFilesObject(String region, String container, String path) {
        this(region, container);
        this.path = path;
    }

    private CloudFilesObject(String region, String container) {
        this.region = region;
        this.container = container;
    }

    public String getRegion() {
        return this.region;
    }

    public String getContainer() {
        return this.container;
    }

    public String getPath() {
        return this.path;
    }

    public Payload getPayload() {
        return this.payload;
    }
}

