/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.dropwizard.reporters;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.druid.emitter.dropwizard.DropwizardReporter;

public class DropwizardConsoleReporter
implements DropwizardReporter {
    private long emitIntervalInSecs;
    private TimeUnit rates = TimeUnit.SECONDS;
    private TimeUnit durations = TimeUnit.MILLISECONDS;
    private ConsoleReporter consoleReporter;

    @JsonProperty
    public long getEmitIntervalInSecs() {
        return this.emitIntervalInSecs;
    }

    @JsonProperty
    public void setEmitIntervalInSecs(long emitIntervalInSecs) {
        this.emitIntervalInSecs = emitIntervalInSecs;
    }

    @JsonProperty
    public TimeUnit getRates() {
        return this.rates;
    }

    @JsonProperty
    public void setRates(String rates) {
        this.rates = TimeUnit.valueOf(rates);
    }

    @JsonProperty
    public TimeUnit getDurations() {
        return this.durations;
    }

    @JsonProperty
    public void setDurations(String durations) {
        this.durations = TimeUnit.valueOf(durations);
    }

    @Override
    public void start(MetricRegistry metricRegistry) {
        this.consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)metricRegistry).convertDurationsTo(this.durations).convertRatesTo(this.rates).build();
        this.consoleReporter.start(this.emitIntervalInSecs, TimeUnit.SECONDS);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.consoleReporter.stop();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropwizardConsoleReporter that = (DropwizardConsoleReporter)o;
        if (this.emitIntervalInSecs != that.emitIntervalInSecs) {
            return false;
        }
        if (this.consoleReporter != null ? !this.consoleReporter.equals(that.consoleReporter) : that.consoleReporter != null) {
            return false;
        }
        if (this.durations != that.durations) {
            return false;
        }
        return this.rates == that.rates;
    }

    public int hashCode() {
        int result = (int)(this.emitIntervalInSecs ^ this.emitIntervalInSecs >>> 32);
        result = 31 * result + (this.rates != null ? this.rates.hashCode() : 0);
        result = 31 * result + (this.durations != null ? this.durations.hashCode() : 0);
        result = 31 * result + (this.consoleReporter != null ? this.consoleReporter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DropwizardConsoleReporter{emitIntervalInSecs=" + this.emitIntervalInSecs + ", rates=" + this.rates + ", durations=" + this.durations + "}";
    }
}

