/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.dropwizard;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.curator.shaded.com.google.common.io.Closeables;
import org.apache.druid.emitter.dropwizard.DropwizardMetricSpec;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class DropwizardConverter {
    private static final Logger log = new Logger(DropwizardConverter.class);
    private final Map<String, DropwizardMetricSpec> metricMap;

    public DropwizardConverter(ObjectMapper mapper, String dimensionMapPath) {
        this.metricMap = this.readMap(mapper, dimensionMapPath);
    }

    @Nullable
    public DropwizardMetricSpec addFilteredUserDims(String service, String metric, Map<String, Object> userDims, Map<String, String> filteredDimensions) {
        DropwizardMetricSpec metricSpec = null;
        DropwizardMetricSpec dropwizardMetricSpec = this.metricMap.get(metric);
        if (dropwizardMetricSpec != null) {
            metricSpec = dropwizardMetricSpec;
        } else if (this.metricMap.containsKey(service + "-" + metric)) {
            metricSpec = this.metricMap.get(service + "-" + metric);
        }
        if (metricSpec != null) {
            for (String dim : metricSpec.getDimensions()) {
                if (!userDims.containsKey(dim)) continue;
                filteredDimensions.put(dim, userDims.get(dim).toString());
            }
            return metricSpec;
        }
        return null;
    }

    private Map<String, DropwizardMetricSpec> readMap(ObjectMapper mapper, String dimensionMapPath) {
        Map map;
        InputStream is = null;
        try {
            if (Strings.isNullOrEmpty((String)dimensionMapPath)) {
                log.info("Using default metric dimension and types", new Object[0]);
                is = this.getClass().getClassLoader().getResourceAsStream("defaultMetricDimensions.json");
            } else {
                log.info("Using metric dimensions at types at [%s]", new Object[]{dimensionMapPath});
                is = new FileInputStream(new File(dimensionMapPath));
            }
            map = (Map)mapper.readerFor((TypeReference)new TypeReference<Map<String, DropwizardMetricSpec>>(){}).readValue(is);
        }
        catch (IOException e) {
            try {
                throw new ISE((Throwable)e, "Failed to parse metric dimensions and types", new Object[0]);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(is);
                throw throwable;
            }
        }
        Closeables.closeQuietly((InputStream)is);
        return map;
    }
}

