/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.http;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.apache.druid.sql.http.ResultFormat;

public class ArrayWriter
implements ResultFormat.Writer {
    private final SerializerProvider serializers;
    private final JsonGenerator jsonGenerator;
    private final OutputStream outputStream;

    public ArrayWriter(OutputStream outputStream, ObjectMapper jsonMapper) throws IOException {
        this.serializers = jsonMapper.getSerializerProviderInstance();
        this.jsonGenerator = jsonMapper.getFactory().createGenerator(outputStream);
        this.outputStream = outputStream;
    }

    @Override
    public void writeResponseStart() throws IOException {
        this.jsonGenerator.writeStartArray();
    }

    @Override
    public void writeResponseEnd() throws IOException {
        this.jsonGenerator.writeEndArray();
        this.jsonGenerator.flush();
        this.outputStream.write(10);
    }

    @Override
    public void writeHeader(RelDataType rowType, boolean includeTypes, boolean includeSqlTypes) throws IOException {
        ArrayWriter.writeHeader(this.jsonGenerator, rowType, includeTypes, includeSqlTypes);
    }

    @Override
    public void writeHeaderFromRowSignature(RowSignature rowSignature, boolean includeTypes) throws IOException {
        ArrayWriter.writeHeader(this.jsonGenerator, rowSignature, includeTypes);
    }

    @Override
    public void writeRowStart() throws IOException {
        this.jsonGenerator.writeStartArray();
    }

    @Override
    public void writeRowField(String name, @Nullable Object value) throws IOException {
        JacksonUtils.writeObjectUsingSerializerProvider((JsonGenerator)this.jsonGenerator, (SerializerProvider)this.serializers, (Object)value);
    }

    @Override
    public void writeRowEnd() throws IOException {
        this.jsonGenerator.writeEndArray();
    }

    @Override
    public void close() throws IOException {
        this.jsonGenerator.close();
    }

    static void writeHeader(JsonGenerator jsonGenerator, RelDataType rowType, boolean includeTypes, boolean includeSqlTypes) throws IOException {
        RowSignature signature = RowSignatures.fromRelDataType(rowType.getFieldNames(), rowType);
        jsonGenerator.writeStartArray();
        for (String columnName : signature.getColumnNames()) {
            jsonGenerator.writeString(columnName);
        }
        jsonGenerator.writeEndArray();
        if (includeTypes) {
            jsonGenerator.writeStartArray();
            for (int i = 0; i < signature.size(); ++i) {
                jsonGenerator.writeString((String)signature.getColumnType(i).map(TypeSignature::asTypeString).orElse(null));
            }
            jsonGenerator.writeEndArray();
        }
        if (includeSqlTypes) {
            jsonGenerator.writeStartArray();
            for (int i = 0; i < signature.size(); ++i) {
                jsonGenerator.writeString(((RelDataTypeField)rowType.getFieldList().get(i)).getType().getSqlTypeName().getName());
            }
            jsonGenerator.writeEndArray();
        }
    }

    static void writeHeader(JsonGenerator jsonGenerator, RowSignature signature, boolean includeTypes) throws IOException {
        jsonGenerator.writeStartArray();
        for (String columnName : signature.getColumnNames()) {
            jsonGenerator.writeString(columnName);
        }
        jsonGenerator.writeEndArray();
        if (includeTypes) {
            jsonGenerator.writeStartArray();
            for (int i = 0; i < signature.size(); ++i) {
                jsonGenerator.writeString((String)signature.getColumnType(i).map(TypeSignature::asTypeString).orElse(null));
            }
            jsonGenerator.writeEndArray();
        }
    }
}

