/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;

public class DruidAggregate
extends Aggregate
implements DruidLogicalNode {
    private final PlannerContext plannerContext;

    public DruidAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, PlannerContext plannerContext) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() instanceof DruidLogicalConvention);
        this.plannerContext = plannerContext;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount((RelNode)this);
        double cost = 0.25 * (double)this.getGroupSet().size();
        for (AggregateCall aggregateCall : this.getAggCallList()) {
            if (aggregateCall.hasFilter()) {
                cost += 0.005000000000000001;
                continue;
            }
            cost += 0.05;
        }
        if (!this.plannerContext.getPlannerConfig().isUseApproximateCountDistinct() && this.getAggCallList().stream().anyMatch(AggregateCall::isDistinct)) {
            return planner.getCostFactory().makeInfiniteCost();
        }
        return planner.getCostFactory().makeCost(rowCount, cost, 0.0);
    }

    public final Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        return new DruidAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls, this.plannerContext);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("druid", (Object)"logical");
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return mq.getRowCount((RelNode)this);
    }
}

