/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Joiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class BinaryOperatorConversion
implements SqlOperatorConversion {
    private final SqlOperator operator;
    private final Joiner joiner;

    public BinaryOperatorConversion(SqlOperator operator, String druidOperator) {
        this.operator = operator;
        this.joiner = Joiner.on((String)(" " + druidOperator + " "));
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, this.getOperatorFunction(rexNode));
    }

    @Override
    @Nullable
    public DruidExpression toDruidExpressionWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor) {
        return OperatorConversions.convertCallWithPostAggOperands(plannerContext, rowSignature, rexNode, this.getOperatorFunction(rexNode), postAggregatorVisitor);
    }

    private DruidExpression.DruidExpressionCreator getOperatorFunction(RexNode rexNode) {
        return operands -> {
            if (operands.size() < 2) {
                throw new ISE("Got binary operator[%s] with %s args", new Object[]{this.operator.getName(), operands.size()});
            }
            return DruidExpression.ofExpression(Calcites.getColumnTypeForRelDataType(rexNode.getType()), args -> StringUtils.format((String)"(%s)", (Object[])new Object[]{this.joiner.join((Iterable)args.stream().map(DruidExpression::getExpression).collect(Collectors.toList()))}), operands);
        };
    }
}

