/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.CountSqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SumSqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class AvgSqlAggregator
implements SqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlStdOperatorTable.AVG;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        String fieldName;
        List<DruidExpression> arguments = Aggregations.getArgumentsForSimpleAggregator(plannerContext, aggregateCall, inputAccessor);
        if (arguments == null) {
            return null;
        }
        String countName = Calcites.makePrefixedName(name, "count");
        AggregatorFactory count = CountSqlAggregator.createCountAggregatorFactory(countName, plannerContext, inputAccessor.getInputRowSignature(), virtualColumnRegistry, inputAccessor.getRexBuilder(), aggregateCall, inputAccessor);
        DruidExpression arg = (DruidExpression)Iterables.getOnlyElement(arguments);
        ExprMacroTable macroTable = plannerContext.getPlannerToolbox().exprMacroTable();
        ColumnType sumType = SqlTypeName.INT_TYPES.contains(aggregateCall.getType().getSqlTypeName()) ? ColumnType.LONG : ColumnType.DOUBLE;
        if (arg.isDirectColumnAccess()) {
            fieldName = arg.getDirectColumn();
        } else {
            RexNode resolutionArg = inputAccessor.getField((Integer)Iterables.getOnlyElement((Iterable)aggregateCall.getArgList()));
            fieldName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, resolutionArg.getType());
        }
        String sumName = Calcites.makePrefixedName(name, "sum");
        AggregatorFactory sum = SumSqlAggregator.createSumAggregatorFactory(sumType, sumName, fieldName, macroTable);
        return Aggregation.create((List<AggregatorFactory>)ImmutableList.of((Object)sum, (Object)count), (PostAggregator)new ArithmeticPostAggregator(name, "quotient", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, sumName), (Object)new FieldAccessPostAggregator(null, countName))));
    }
}

