/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.Objects;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;

public class DruidVolcanoCost
implements RelOptCost {
    static final DruidVolcanoCost INFINITY = new DruidVolcanoCost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public String toString() {
            return "{inf}";
        }
    };
    static final DruidVolcanoCost HUGE = new DruidVolcanoCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        public String toString() {
            return "{huge}";
        }
    };
    static final DruidVolcanoCost ZERO = new DruidVolcanoCost(0.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{0}";
        }
    };
    static final DruidVolcanoCost TINY = new DruidVolcanoCost(1.0, 1.0, 0.0){

        @Override
        public String toString() {
            return "{tiny}";
        }
    };
    public static final RelOptCostFactory FACTORY = new Factory();
    final double cpu;
    final double io;
    final double rowCount;

    DruidVolcanoCost(double rowCount, double cpu, double io) {
        this.rowCount = rowCount;
        this.cpu = cpu;
        this.io = io;
    }

    public double getCpu() {
        return this.cpu;
    }

    public boolean isInfinite() {
        return this == INFINITY || this.rowCount == Double.POSITIVE_INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY;
    }

    public double getIo() {
        return this.io;
    }

    public boolean isLe(RelOptCost other) {
        DruidVolcanoCost that = (DruidVolcanoCost)other;
        return this == that || this.rowCount < that.rowCount || this.rowCount == that.rowCount && this.cpu < that.cpu || this.rowCount == that.rowCount && this.cpu == that.cpu && this.io <= that.io;
    }

    public boolean isLt(RelOptCost other) {
        return this.isLe(other) && !this.equals(other);
    }

    public double getRows() {
        return this.rowCount;
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.cpu, this.io);
    }

    public boolean equals(RelOptCost other) {
        return this == other || other instanceof DruidVolcanoCost && this.rowCount == ((DruidVolcanoCost)other).rowCount && this.cpu == ((DruidVolcanoCost)other).cpu && this.io == ((DruidVolcanoCost)other).io;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DruidVolcanoCost) {
            return this.equals((DruidVolcanoCost)obj);
        }
        return false;
    }

    public boolean isEqWithEpsilon(RelOptCost other) {
        if (!(other instanceof DruidVolcanoCost)) {
            return false;
        }
        DruidVolcanoCost that = (DruidVolcanoCost)other;
        return this == that || Math.abs(this.rowCount - that.rowCount) < 1.0E-5 && Math.abs(this.cpu - that.cpu) < 1.0E-5 && Math.abs(this.io - that.io) < 1.0E-5;
    }

    public RelOptCost minus(RelOptCost other) {
        if (this == INFINITY) {
            return this;
        }
        DruidVolcanoCost that = (DruidVolcanoCost)other;
        return new DruidVolcanoCost(this.rowCount - that.rowCount, this.cpu - that.cpu, this.io - that.io);
    }

    public RelOptCost multiplyBy(double factor) {
        if (this == INFINITY) {
            return this;
        }
        return new DruidVolcanoCost(this.rowCount * factor, this.cpu * factor, this.io * factor);
    }

    public double divideBy(RelOptCost cost) {
        DruidVolcanoCost that = (DruidVolcanoCost)cost;
        double d = 1.0;
        double n = 0.0;
        if (this.rowCount != 0.0 && !Double.isInfinite(this.rowCount) && that.rowCount != 0.0 && !Double.isInfinite(that.rowCount)) {
            d *= this.rowCount / that.rowCount;
            n += 1.0;
        }
        if (this.cpu != 0.0 && !Double.isInfinite(this.cpu) && that.cpu != 0.0 && !Double.isInfinite(that.cpu)) {
            d *= this.cpu / that.cpu;
            n += 1.0;
        }
        if (this.io != 0.0 && !Double.isInfinite(this.io) && that.io != 0.0 && !Double.isInfinite(that.io)) {
            d *= this.io / that.io;
            n += 1.0;
        }
        if (n == 0.0) {
            return 1.0;
        }
        return Math.pow(d, 1.0 / n);
    }

    public RelOptCost plus(RelOptCost other) {
        DruidVolcanoCost that = (DruidVolcanoCost)other;
        if (this == INFINITY || that == INFINITY) {
            return INFINITY;
        }
        return new DruidVolcanoCost(this.rowCount + that.rowCount, this.cpu + that.cpu, this.io + that.io);
    }

    public String toString() {
        return "{" + this.rowCount + " rows, " + this.cpu + " cpu, " + this.io + " io}";
    }

    public static class Factory
    implements RelOptCostFactory {
        public RelOptCost makeCost(double dRows, double dCpu, double dIo) {
            return new DruidVolcanoCost(dRows, dCpu, dIo);
        }

        public RelOptCost makeHugeCost() {
            return HUGE;
        }

        public RelOptCost makeInfiniteCost() {
            return INFINITY;
        }

        public RelOptCost makeTinyCost() {
            return TINY;
        }

        public RelOptCost makeZeroCost() {
            return ZERO;
        }
    }
}

