/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.sql.calcite.schema.NamedSchema;

public class DruidSchemaCatalog {
    private final SchemaPlus rootSchema;
    private final Map<String, NamedSchema> namedSchemas;

    public DruidSchemaCatalog(SchemaPlus rootSchema, Map<String, NamedSchema> schemas) {
        this.rootSchema = rootSchema;
        this.namedSchemas = schemas;
    }

    public SchemaPlus getRootSchema() {
        return this.rootSchema;
    }

    public Map<String, NamedSchema> getNamedSchemas() {
        return this.namedSchemas;
    }

    public NamedSchema getNamedSchema(String schemaName) {
        return this.namedSchemas.get(schemaName);
    }

    public SchemaPlus getSubSchema(String name) {
        return this.rootSchema.getSubSchema(name);
    }

    public Set<String> getSubSchemaNames() {
        return this.rootSchema.getSubSchemaNames();
    }

    @Nullable
    public String getResourceType(String schema, String resourceName) {
        NamedSchema namedSchema = this.namedSchemas.get(schema);
        return namedSchema == null ? null : namedSchema.getSchemaResourceType(resourceName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidSchemaCatalog that = (DruidSchemaCatalog)o;
        return this.rootSchema.equals((Object)that.rootSchema) && this.namedSchemas.equals(that.namedSchemas);
    }

    public int hashCode() {
        return Objects.hash(this.rootSchema, this.namedSchemas);
    }

    public String toString() {
        return "DruidSchemaCatalog{schemas=" + String.valueOf(this.getSubSchemaNames()) + "}";
    }
}

