/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlUnknownLiteral;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.sql.calcite.expression.TimeUnits;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.filtration.MoveTimeFiltersToIntervals;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.base.AbstractInterval;

public class DruidSqlParserUtils {
    private static final Logger log = new Logger(DruidSqlParserUtils.class);
    public static final String ALL = "all";
    private static final List<GranularityType> DOCUMENTED_GRANULARITIES = Arrays.stream(GranularityType.values()).filter(g -> g != GranularityType.WEEK && g != GranularityType.NONE).collect(Collectors.toList());

    @Nullable
    public static Granularity convertSqlNodeToGranularity(SqlNode sqlNode) {
        if (sqlNode == null) {
            return null;
        }
        if (sqlNode instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)sqlNode;
            if (!SqlLiteral.valueMatchesType((Object)literal.getValue(), (SqlTypeName)SqlTypeName.CHAR)) {
                throw DruidSqlParserUtils.makeInvalidPartitionByException((SqlNode)literal);
            }
            Granularity retVal = DruidSqlParserUtils.convertSqlLiteralCharToGranularity(literal);
            DruidSqlParserUtils.validateSupportedGranularityForPartitionedBy(sqlNode, retVal);
            return retVal;
        }
        if (sqlNode instanceof SqlIdentifier) {
            SqlIdentifier identifier = (SqlIdentifier)sqlNode;
            Granularity retVal = DruidSqlParserUtils.convertSqlIdentiferToGranularity(identifier);
            DruidSqlParserUtils.validateSupportedGranularityForPartitionedBy(sqlNode, retVal);
            return retVal;
        }
        if (!(sqlNode instanceof SqlCall)) {
            throw DruidSqlParserUtils.makeInvalidPartitionByException(sqlNode);
        }
        SqlCall sqlCall = (SqlCall)sqlNode;
        String operatorName = sqlCall.getOperator().getName();
        if (!SqlStdOperatorTable.FLOOR.getName().equalsIgnoreCase(operatorName) && !"TIME_FLOOR".equalsIgnoreCase(operatorName)) {
            throw InvalidSqlInput.exception((String)"Invalid operator[%s] specified. PARTITIONED BY clause only supports %s(__time TO <unit>) and %s(__time, period) functions.", (Object[])new Object[]{operatorName, SqlStdOperatorTable.FLOOR.getName(), "TIME_FLOOR"});
        }
        List operandList = sqlCall.getOperandList();
        if (operandList.size() != 2) {
            throw InvalidSqlInput.exception((String)"%s in PARTITIONED BY clause must have 2 arguments, but only [%d] provided.", (Object[])new Object[]{operatorName, operandList.size()});
        }
        SqlNode timeOperandSqlNode = (SqlNode)operandList.get(0);
        if (!SqlKind.IDENTIFIER.equals((Object)timeOperandSqlNode.getKind())) {
            throw InvalidSqlInput.exception((String)"Invalid argument type[%s] provided. The first argument to %s in PARTITIONED BY clause must be __time.", (Object[])new Object[]{timeOperandSqlNode.getKind(), operatorName});
        }
        SqlIdentifier timeOperandSqlIdentifier = (SqlIdentifier)timeOperandSqlNode;
        if (!"__time".equals(timeOperandSqlIdentifier.getSimple())) {
            throw InvalidSqlInput.exception((String)"Invalid argument[%s] provided. The first argument to %s in PARTITIONED BY clause must be __time.", (Object[])new Object[]{timeOperandSqlIdentifier.getSimple(), operatorName});
        }
        if ("TIME_FLOOR".equalsIgnoreCase(operatorName)) {
            Period period;
            SqlNode granularitySqlNode = (SqlNode)operandList.get(1);
            if (!SqlKind.LITERAL.equals((Object)granularitySqlNode.getKind())) {
                throw InvalidSqlInput.exception((String)"Invalid argument[%s] provided. The second argument to %s in PARTITIONED BY clause must be a period like 'PT1H'.", (Object[])new Object[]{granularitySqlNode.getKind(), "TIME_FLOOR"});
            }
            String granularityString = SqlLiteral.unchain((SqlNode)granularitySqlNode).toValue();
            try {
                period = new Period((Object)granularityString);
            }
            catch (IllegalArgumentException e) {
                throw InvalidSqlInput.exception((String)"granularity[%s] is an invalid period literal.", (Object[])new Object[]{granularitySqlNode.toString()});
            }
            PeriodGranularity retVal = new PeriodGranularity(period, null, null);
            DruidSqlParserUtils.validateSupportedGranularityForPartitionedBy(sqlNode, (Granularity)retVal);
            return retVal;
        }
        if (SqlStdOperatorTable.FLOOR.getName().equalsIgnoreCase(operatorName)) {
            SqlNode granularitySqlNode = (SqlNode)operandList.get(1);
            if (!(granularitySqlNode instanceof SqlIntervalQualifier)) {
                throw InvalidSqlInput.exception((String)"Second argument[%s] to the FLOOR function in PARTITIONED BY clause is not a valid granularity. Please refer to the documentation of FLOOR function.", (Object[])new Object[]{granularitySqlNode.toString()});
            }
            SqlIntervalQualifier granularityIntervalQualifier = (SqlIntervalQualifier)granularitySqlNode;
            Period period = TimeUnits.toPeriod(granularityIntervalQualifier.timeUnitRange);
            if (period == null) {
                throw InvalidSqlInput.exception((String)"%s is not a valid period granularity for ingestion.", (Object[])new Object[]{granularityIntervalQualifier.timeUnitRange.toString()});
            }
            PeriodGranularity retVal = new PeriodGranularity(period, null, null);
            DruidSqlParserUtils.validateSupportedGranularityForPartitionedBy(sqlNode, (Granularity)retVal);
            return retVal;
        }
        throw DruidSqlParserUtils.makeInvalidPartitionByException(sqlNode);
    }

    private static Granularity convertSqlLiteralCharToGranularity(SqlLiteral literal) {
        return DruidSqlParserUtils.convertStringToGranularity((String)literal.getValueAs(String.class), (SqlNode)literal);
    }

    private static Granularity convertSqlIdentiferToGranularity(SqlIdentifier identifier) {
        if (identifier.names.isEmpty()) {
            throw DruidSqlParserUtils.makeInvalidPartitionByException((SqlNode)identifier);
        }
        return DruidSqlParserUtils.convertStringToGranularity((String)identifier.names.get(0), (SqlNode)identifier);
    }

    private static Granularity convertStringToGranularity(String value, SqlNode node) {
        try {
            return Granularity.fromString((String)value);
        }
        catch (IllegalArgumentException e) {
            try {
                return new PeriodGranularity(new Period((Object)value), null, null);
            }
            catch (Exception e2) {
                throw DruidSqlParserUtils.makeInvalidPartitionByException(node);
            }
        }
    }

    private static DruidException makeInvalidPartitionByException(SqlNode sqlNode) {
        return InvalidSqlInput.exception((String)("Invalid granularity[%s] specified after PARTITIONED BY clause. Expected " + DOCUMENTED_GRANULARITIES.stream().map(granularityType -> "'" + granularityType.name() + "'").collect(Collectors.joining(", ")) + ", ALL TIME, FLOOR() or TIME_FLOOR()"), (Object[])new Object[]{sqlNode});
    }

    public static List<String> validateQueryAndConvertToIntervals(SqlNode replaceTimeQuery, Granularity granularity, DateTimeZone dateTimeZone) {
        if (replaceTimeQuery instanceof SqlLiteral && ALL.equalsIgnoreCase(((SqlLiteral)replaceTimeQuery).toValue())) {
            return ImmutableList.of((Object)ALL);
        }
        DimFilter dimFilter = DruidSqlParserUtils.convertQueryToDimFilter(replaceTimeQuery, dateTimeZone);
        Filtration filtration = Filtration.create(dimFilter);
        filtration = MoveTimeFiltersToIntervals.instance().apply(filtration);
        List<Interval> intervals = filtration.getIntervals();
        if (filtration.getDimFilter() != null) {
            throw InvalidSqlInput.exception((String)"OVERWRITE WHERE clause only supports filtering on the __time column, got [%s]", (Object[])new Object[]{filtration.getDimFilter()});
        }
        if (intervals.isEmpty()) {
            throw InvalidSqlInput.exception((String)"The OVERWRITE WHERE clause [%s] produced no time intervals, are the bounds overly restrictive?", (Object[])new Object[]{dimFilter, intervals});
        }
        for (Interval interval : intervals) {
            DateTime intervalStart = interval.getStart();
            DateTime intervalEnd = interval.getEnd();
            if (granularity.bucketStart(intervalStart).equals((Object)intervalStart) && granularity.bucketStart(intervalEnd).equals((Object)intervalEnd)) continue;
            throw InvalidSqlInput.exception((String)"OVERWRITE WHERE clause identified interval [%s] which is not aligned with PARTITIONED BY granularity [%s]", (Object[])new Object[]{interval, granularity});
        }
        return intervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
    }

    public static SqlOrderBy convertClusterByToOrderBy(SqlNode query, SqlNodeList clusteredByList) {
        DruidSqlParserUtils.validateClusteredByColumns(clusteredByList);
        SqlNode offset = null;
        SqlNode fetch = null;
        if (query instanceof SqlOrderBy) {
            SqlOrderBy sqlOrderBy = (SqlOrderBy)query;
            query = sqlOrderBy.query;
            offset = sqlOrderBy.offset;
            fetch = sqlOrderBy.fetch;
        }
        return new SqlOrderBy(query.getParserPosition(), query, clusteredByList, offset, fetch);
    }

    @Nullable
    public static List<String> resolveClusteredByColumnsToOutputColumns(SqlNodeList clusteredByNodes, List<Map.Entry<Integer, String>> sourceFieldMappings) {
        if (clusteredByNodes == null) {
            return null;
        }
        ArrayList<String> retClusteredByNames = new ArrayList<String>();
        for (SqlNode clusteredByNode : clusteredByNodes) {
            if (clusteredByNode instanceof SqlNumericLiteral) {
                int ordinal = (Integer)((SqlNumericLiteral)clusteredByNode).getValueAs(Integer.class);
                retClusteredByNames.add(sourceFieldMappings.get(ordinal - 1).getValue());
                continue;
            }
            if (clusteredByNode instanceof SqlBasicCall) {
                retClusteredByNames.add(DruidSqlParserUtils.getColumnNameFromSqlCall((SqlBasicCall)clusteredByNode));
                continue;
            }
            retClusteredByNames.add(clusteredByNode.toString());
        }
        return retClusteredByNames;
    }

    private static String getColumnNameFromSqlCall(SqlBasicCall sqlCallNode) {
        if (sqlCallNode.getOperator() instanceof SqlAsOperator) {
            SqlNode sqlNode = (SqlNode)sqlCallNode.getOperandList().get(1);
            return sqlNode.toString();
        }
        return sqlCallNode.toSqlString(CalciteSqlDialect.DEFAULT).toString();
    }

    @VisibleForTesting
    public static void validateClusteredByColumns(SqlNodeList clusteredByNodes) {
        if (clusteredByNodes == null) {
            return;
        }
        for (SqlNode clusteredByNode : clusteredByNodes.getList()) {
            int ordinal;
            if (clusteredByNode.isA((Set)ImmutableSet.of((Object)SqlKind.DESCENDING))) {
                throw InvalidSqlInput.exception((String)"Invalid CLUSTERED BY clause [%s]: cannot sort in descending order.", (Object[])new Object[]{clusteredByNode});
            }
            if (!(clusteredByNode instanceof SqlNumericLiteral) || (ordinal = ((Integer)((SqlNumericLiteral)clusteredByNode).getValueAs(Integer.class)).intValue()) >= 1) continue;
            throw InvalidSqlInput.exception((String)"Ordinal [%d] specified in the CLUSTERED BY clause is invalid. It must be a positive integer.", (Object[])new Object[]{ordinal});
        }
    }

    private static DimFilter convertQueryToDimFilter(SqlNode replaceTimeQuery, DateTimeZone dateTimeZone) {
        if (!(replaceTimeQuery instanceof SqlBasicCall)) {
            throw InvalidSqlInput.exception((String)"Invalid OVERWRITE WHERE clause [%s]: expected clause including AND, OR, NOT, >, <, >=, <= OR BETWEEN operators", (Object[])new Object[]{replaceTimeQuery});
        }
        try {
            SqlBasicCall sqlBasicCall = (SqlBasicCall)replaceTimeQuery;
            List operandList = sqlBasicCall.getOperandList();
            switch (sqlBasicCall.getOperator().getKind()) {
                case AND: {
                    ArrayList<DimFilter> dimFilters = new ArrayList<DimFilter>();
                    for (SqlNode sqlNode : sqlBasicCall.getOperandList()) {
                        dimFilters.add(DruidSqlParserUtils.convertQueryToDimFilter(sqlNode, dateTimeZone));
                    }
                    return new AndDimFilter(dimFilters);
                }
                case OR: {
                    ArrayList<DimFilter> dimFilters = new ArrayList<DimFilter>();
                    for (SqlNode sqlNode : sqlBasicCall.getOperandList()) {
                        dimFilters.add(DruidSqlParserUtils.convertQueryToDimFilter(sqlNode, dateTimeZone));
                    }
                    return new OrDimFilter(dimFilters);
                }
                case NOT: {
                    return new NotDimFilter(DruidSqlParserUtils.convertQueryToDimFilter((SqlNode)sqlBasicCall.getOperandList().get(0), dateTimeZone));
                }
                case GREATER_THAN_OR_EQUAL: {
                    String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                    return new BoundDimFilter(columnName, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(false), null, null, null, StringComparators.NUMERIC);
                }
                case LESS_THAN_OR_EQUAL: {
                    String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                    return new BoundDimFilter(columnName, null, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(false), null, null, StringComparators.NUMERIC);
                }
                case GREATER_THAN: {
                    String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                    return new BoundDimFilter(columnName, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(true), null, null, null, StringComparators.NUMERIC);
                }
                case LESS_THAN: {
                    String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                    return new BoundDimFilter(columnName, null, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), null, Boolean.valueOf(true), null, null, StringComparators.NUMERIC);
                }
                case BETWEEN: {
                    String columnName = DruidSqlParserUtils.parseColumnName((SqlNode)operandList.get(0));
                    return new BoundDimFilter(columnName, DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(1), dateTimeZone), DruidSqlParserUtils.parseTimeStampWithTimeZone((SqlNode)operandList.get(2), dateTimeZone), Boolean.valueOf(false), Boolean.valueOf(false), null, null, StringComparators.NUMERIC);
                }
            }
            throw InvalidSqlInput.exception((String)"Unsupported operation [%s] in OVERWRITE WHERE clause.", (Object[])new Object[]{sqlBasicCall.getOperator().getName()});
        }
        catch (DruidException e) {
            throw e.prependAndBuild("Invalid OVERWRITE WHERE clause [%s]", new Object[]{replaceTimeQuery});
        }
    }

    public static String parseColumnName(SqlNode sqlNode) {
        if (!(sqlNode instanceof SqlIdentifier)) {
            throw InvalidSqlInput.exception((String)"Cannot parse column name from SQL expression [%s]", (Object[])new Object[]{sqlNode});
        }
        return ((SqlIdentifier)sqlNode).getSimple();
    }

    static String parseTimeStampWithTimeZone(SqlNode sqlNode, DateTimeZone timeZone) {
        if (sqlNode instanceof SqlUnknownLiteral) {
            Timestamp sqlTimestamp;
            try {
                SqlTimestampLiteral timestampLiteral = (SqlTimestampLiteral)((SqlUnknownLiteral)sqlNode).resolve(SqlTypeName.TIMESTAMP);
                sqlTimestamp = Timestamp.valueOf(timestampLiteral.toFormattedString());
            }
            catch (Exception e) {
                throw InvalidSqlInput.exception((String)"Cannot get a timestamp from sql expression [%s]", (Object[])new Object[]{sqlNode});
            }
            ZonedDateTime zonedTimestamp = sqlTimestamp.toLocalDateTime().atZone(timeZone.toTimeZone().toZoneId());
            return String.valueOf(zonedTimestamp.toInstant().toEpochMilli());
        }
        if (!(sqlNode instanceof SqlTimestampLiteral)) {
            throw InvalidSqlInput.exception((String)"Cannot get a timestamp from sql expression [%s]", (Object[])new Object[]{sqlNode});
        }
        Timestamp sqlTimestamp = Timestamp.valueOf(((SqlTimestampLiteral)sqlNode).toFormattedString());
        ZonedDateTime zonedTimestamp = sqlTimestamp.toLocalDateTime().atZone(timeZone.toTimeZone().toZoneId());
        return String.valueOf(zonedTimestamp.toInstant().toEpochMilli());
    }

    public static void validateSupportedGranularityForPartitionedBy(@Nullable SqlNode originalNode, Granularity granularity) {
        if (!GranularityType.isStandard((Granularity)granularity)) {
            throw DruidSqlParserUtils.makeInvalidPartitionByException(originalNode);
        }
    }

    public static DruidException problemParsing(String message) {
        return InvalidSqlInput.exception((String)message, (Object[])new Object[0]);
    }
}

