/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.IsTrueDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.sql.calcite.filtration.Filtration;

public class RemoveRedundantIsTrue
implements Function<Filtration, Filtration> {
    private static final RemoveRedundantIsTrue INSTANCE = new RemoveRedundantIsTrue();

    public static RemoveRedundantIsTrue instance() {
        return INSTANCE;
    }

    public Filtration apply(Filtration filtration) {
        if (filtration.getDimFilter() != null) {
            Filtration retVal = Filtration.create(this.apply0(filtration.getDimFilter()), filtration.getIntervals());
            return filtration.equals(retVal) ? retVal : this.apply(retVal);
        }
        return filtration;
    }

    private DimFilter apply0(DimFilter filter) {
        if (filter instanceof AndDimFilter) {
            List oldFilters = ((AndDimFilter)filter).getFields();
            ArrayList<DimFilter> newFilters = new ArrayList<DimFilter>();
            for (DimFilter oldFilter : oldFilters) {
                DimFilter newFilter = this.apply0(oldFilter);
                if (newFilter == null) continue;
                newFilters.add(newFilter);
            }
            if (!newFilters.equals(oldFilters)) {
                return new AndDimFilter(newFilters);
            }
            return filter;
        }
        if (filter instanceof OrDimFilter) {
            List oldFilters = ((OrDimFilter)filter).getFields();
            ArrayList<DimFilter> newFilters = new ArrayList<DimFilter>();
            for (DimFilter oldFilter : oldFilters) {
                DimFilter newFilter = this.apply0(oldFilter);
                if (newFilter == null) continue;
                newFilters.add(newFilter);
            }
            if (!newFilters.equals(oldFilters)) {
                return new OrDimFilter(newFilters);
            }
            return filter;
        }
        if (filter instanceof IsTrueDimFilter) {
            DimFilter newFilter;
            DimFilter oldFilter = ((IsTrueDimFilter)filter).getField();
            if (!oldFilter.equals(newFilter = this.apply0(oldFilter))) {
                return newFilter;
            }
            return oldFilter;
        }
        return filter;
    }
}

