/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.query.BadQueryException;

public class SqlPlanningException
extends BadQueryException {
    public SqlPlanningException(SqlParseException e) {
        this((Throwable)e, PlanningError.SQL_PARSE_ERROR, e.getMessage());
    }

    public SqlPlanningException(ValidationException e) {
        this((Throwable)e, PlanningError.VALIDATION_ERROR, e.getMessage());
    }

    public SqlPlanningException(CalciteContextException e) {
        this((Throwable)e, PlanningError.VALIDATION_ERROR, e.getMessage());
    }

    public SqlPlanningException(PlanningError planningError, String errorMessage) {
        this(null, planningError, errorMessage);
    }

    public SqlPlanningException(Throwable cause, PlanningError planningError, String errorMessage) {
        this(cause, planningError.errorCode, errorMessage, planningError.errorClass);
    }

    @JsonCreator
    private SqlPlanningException(@JsonProperty(value="error") String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") String errorClass) {
        this(null, errorCode, errorMessage, errorClass);
    }

    private SqlPlanningException(Throwable cause, String errorCode, String errorMessage, String errorClass) {
        super(cause, errorCode, errorMessage, errorClass, null);
    }

    public static enum PlanningError {
        SQL_PARSE_ERROR("SQL parse failed", SqlParseException.class.getName()),
        VALIDATION_ERROR("Plan validation failed", ValidationException.class.getName()),
        UNSUPPORTED_SQL_ERROR("SQL query is unsupported", RelOptPlanner.CannotPlanException.class.getName());

        private final String errorCode;
        private final String errorClass;

        private PlanningError(String errorCode, String errorClass) {
            this.errorCode = errorCode;
            this.errorClass = errorClass;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorClass() {
            return this.errorClass;
        }
    }
}

