/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.filtration.RangeRefKey;
import org.apache.druid.sql.calcite.filtration.RangeValue;
import org.joda.time.Interval;

public class Ranges {
    @Nullable
    public static RangeFilter not(RangeFilter range) {
        if (range.getUpper() != null && range.getLower() != null) {
            return null;
        }
        if (range.getUpper() != null) {
            return new RangeFilter(range.getColumn(), range.getMatchValueType(), range.getUpper(), null, Boolean.valueOf(!range.isUpperOpen()), Boolean.valueOf(false), range.getFilterTuning());
        }
        return new RangeFilter(range.getColumn(), range.getMatchValueType(), null, range.getLower(), Boolean.valueOf(false), Boolean.valueOf(!range.isLowerOpen()), range.getFilterTuning());
    }

    public static Range<RangeValue> toRange(RangeFilter range) {
        RangeValue lower;
        RangeValue upper = range.getUpper() != null ? new RangeValue(range.getUpper(), range.getMatchValueType()) : null;
        RangeValue rangeValue = lower = range.getLower() != null ? new RangeValue(range.getLower(), range.getMatchValueType()) : null;
        if (lower == null) {
            return range.isUpperOpen() ? Range.lessThan((Comparable)upper) : Range.atMost((Comparable)upper);
        }
        if (upper == null) {
            return range.isLowerOpen() ? Range.greaterThan((Comparable)lower) : Range.atLeast((Comparable)lower);
        }
        BoundType lowerBoundType = range.isLowerOpen() ? BoundType.OPEN : BoundType.CLOSED;
        BoundType upperBoundType = range.isUpperOpen() ? BoundType.OPEN : BoundType.CLOSED;
        return Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
    }

    public static Range<RangeValue> toRange(RangeFilter range, ColumnType newMatchValueType) {
        RangeValue lower;
        ExpressionType exprType = ExpressionType.fromColumnType((TypeSignature)newMatchValueType);
        RangeValue upper = range.getUpper() != null ? new RangeValue(ExprEval.ofType((ExpressionType)exprType, (Object)range.getUpper()).valueOrDefault(), newMatchValueType) : null;
        RangeValue rangeValue = lower = range.getLower() != null ? new RangeValue(ExprEval.ofType((ExpressionType)exprType, (Object)range.getLower()).valueOrDefault(), newMatchValueType) : null;
        if (lower == null) {
            return range.isUpperOpen() ? Range.lessThan((Comparable)upper) : Range.atMost((Comparable)upper);
        }
        if (upper == null) {
            return range.isLowerOpen() ? Range.greaterThan((Comparable)lower) : Range.atLeast((Comparable)lower);
        }
        BoundType lowerBoundType = range.isLowerOpen() ? BoundType.OPEN : BoundType.CLOSED;
        BoundType upperBoundType = range.isUpperOpen() ? BoundType.OPEN : BoundType.CLOSED;
        return Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
    }

    public static List<Range<RangeValue>> toRanges(List<RangeFilter> ranges) {
        return ImmutableList.copyOf((Collection)Lists.transform(ranges, Ranges::toRange));
    }

    public static RangeFilter toFilter(RangeRefKey rangeRefKey, Range<RangeValue> range) {
        return new RangeFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), range.hasLowerBound() ? ((RangeValue)range.lowerEndpoint()).getValue() : null, range.hasUpperBound() ? ((RangeValue)range.upperEndpoint()).getValue() : null, Boolean.valueOf(range.hasLowerBound() && range.lowerBoundType() == BoundType.OPEN), Boolean.valueOf(range.hasUpperBound() && range.upperBoundType() == BoundType.OPEN), null);
    }

    public static RangeFilter equalTo(RangeRefKey rangeRefKey, Object value) {
        Object castValue = Ranges.castVal(rangeRefKey, value);
        return new RangeFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), castValue, castValue, Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public static RangeFilter greaterThan(RangeRefKey rangeRefKey, Object value) {
        return new RangeFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), Ranges.castVal(rangeRefKey, value), null, Boolean.valueOf(true), Boolean.valueOf(false), null);
    }

    public static RangeFilter greaterThanOrEqualTo(RangeRefKey rangeRefKey, Object value) {
        return new RangeFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), Ranges.castVal(rangeRefKey, value), null, Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public static RangeFilter lessThan(RangeRefKey rangeRefKey, Object value) {
        return new RangeFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), null, Ranges.castVal(rangeRefKey, value), Boolean.valueOf(false), Boolean.valueOf(true), null);
    }

    public static RangeFilter lessThanOrEqualTo(RangeRefKey rangeRefKey, Object value) {
        return new RangeFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), null, Ranges.castVal(rangeRefKey, value), Boolean.valueOf(false), Boolean.valueOf(false), null);
    }

    public static RangeFilter interval(RangeRefKey rangeRefKey, Interval interval) {
        if (!rangeRefKey.getMatchValueType().equals((Object)ColumnType.LONG)) {
            throw new ISE("Comparator must be LONG but was[%s]", new Object[]{rangeRefKey.getMatchValueType()});
        }
        return new RangeFilter(rangeRefKey.getColumn(), rangeRefKey.getMatchValueType(), (Object)interval.getStartMillis(), (Object)interval.getEndMillis(), Boolean.valueOf(false), Boolean.valueOf(true), null);
    }

    private static Object castVal(RangeRefKey rangeRefKey, Object value) {
        if (value instanceof String || value instanceof Number || value == null) {
            ColumnType columnType = rangeRefKey.getMatchValueType();
            if (columnType.is((TypeDescriptor)ValueType.STRING) && (value instanceof String || value == null)) {
                return value;
            }
            if (columnType.is((TypeDescriptor)ValueType.DOUBLE) && value instanceof Double) {
                return value;
            }
            if (columnType.is((TypeDescriptor)ValueType.LONG) && value instanceof Long) {
                return value;
            }
            ExpressionType expressionType = ExpressionType.fromColumnType((TypeSignature)columnType);
            return ExprEval.ofType((ExpressionType)expressionType, (Object)value).valueOrDefault();
        }
        return value;
    }
}

