/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.expression.AuthorizableOperator;
import org.apache.druid.sql.calcite.external.BaseUserDefinedTableMacro;
import org.apache.druid.sql.calcite.table.ExternalTable;

public abstract class SchemaAwareUserDefinedTableMacro
extends BaseUserDefinedTableMacro
implements AuthorizableOperator {
    public SchemaAwareUserDefinedTableMacro(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandMetadata operandMetadata, ExtendedTableMacro tableMacro) {
        super(opName, returnTypeInference, operandTypeInference, operandMetadata, tableMacro);
    }

    public SqlBasicCall rewriteCall(SqlBasicCall oldCall, SqlNodeList schema) {
        return new ExtendedCall(oldCall, new ShimUserDefinedTableMacro(this, schema));
    }

    private static class ExtendedCall
    extends SqlBasicCall {
        private final SqlNodeList schema;

        public ExtendedCall(SqlBasicCall oldCall, ShimUserDefinedTableMacro macro) {
            super((SqlOperator)macro, oldCall.getOperandList(), oldCall.getParserPosition(), oldCall.getFunctionQuantifier());
            this.schema = macro.schema;
        }

        public ExtendedCall(ExtendedCall from, SqlParserPos pos) {
            super(from.getOperator(), from.getOperandList(), pos, from.getFunctionQuantifier());
            this.schema = from.schema;
        }

        public void setOperator(SqlOperator operator) {
        }

        public SqlNode clone(SqlParserPos pos) {
            return new ExtendedCall(this, pos);
        }

        public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
            super.unparse(writer, leftPrec, rightPrec);
            writer.keyword("EXTEND");
            SqlWriter.Frame frame = writer.startList("(", ")");
            this.schema.unparse(writer, leftPrec, rightPrec);
            writer.endList(frame);
        }

        public Object clone() {
            throw new UOE("Not supported", new Object[0]);
        }
    }

    private static class ShimUserDefinedTableMacro
    extends BaseUserDefinedTableMacro
    implements AuthorizableOperator {
        protected final SchemaAwareUserDefinedTableMacro base;
        protected final SqlNodeList schema;
        private TranslatableTable table;

        public ShimUserDefinedTableMacro(SchemaAwareUserDefinedTableMacro base, SqlNodeList schema) {
            super(base.getNameAsId(), ReturnTypes.CURSOR, null, base.getOperandTypeChecker(), new ShimTableMacro((ExtendedTableMacro)base.macro, schema));
            this.base = base;
            this.schema = schema;
        }

        @Override
        public TranslatableTable getTable(SqlOperatorBinding callBinding) {
            if (this.table == null) {
                this.table = super.getTable(callBinding);
            }
            return this.table;
        }

        @Override
        public Set<ResourceAction> computeResources(SqlCall call, boolean inputSourceTypeSecurityEnabled) {
            HashSet<ResourceAction> resourceActions = new HashSet<ResourceAction>();
            if (this.table instanceof ExternalTable && inputSourceTypeSecurityEnabled) {
                resourceActions.addAll(((Set)((ExternalTable)this.table).getInputSourceTypeSupplier().get()).stream().map(AuthorizationUtils::createExternalResourceReadAction).collect(Collectors.toSet()));
            } else {
                resourceActions.addAll(this.base.computeResources(call, inputSourceTypeSecurityEnabled));
            }
            return resourceActions;
        }
    }

    protected static class ShimTableMacro
    implements TableMacro {
        private final ExtendedTableMacro delegate;
        private final SqlNodeList schema;
        private TranslatableTable table;

        public ShimTableMacro(ExtendedTableMacro delegate, SqlNodeList schema) {
            this.delegate = delegate;
            this.schema = schema;
        }

        public TranslatableTable apply(List<?> arguments) {
            if (this.table == null) {
                this.table = this.delegate.apply(arguments, this.schema);
            }
            return this.table;
        }

        public List<FunctionParameter> getParameters() {
            return this.delegate.getParameters();
        }
    }

    public static interface ExtendedTableMacro
    extends TableMacro {
        public TranslatableTable apply(List<?> var1, SqlNodeList var2);
    }
}

