/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.guice.annotations.Merging;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.query.groupby.GroupByStatsProvider;

@LoadScope(roles={"broker", "historical", "indexer", "peon"})
public class GroupByStatsMonitor
extends AbstractMonitor {
    private final GroupByStatsProvider groupByStatsProvider;
    private final BlockingPool<ByteBuffer> mergeBufferPool;

    @Inject
    public GroupByStatsMonitor(GroupByStatsProvider groupByStatsProvider, @Merging BlockingPool<ByteBuffer> mergeBufferPool) {
        this.groupByStatsProvider = groupByStatsProvider;
        this.mergeBufferPool = mergeBufferPool;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
        emitter.emit((ServiceEventBuilder)builder.setMetric("mergeBuffer/pendingRequests", (Number)this.mergeBufferPool.getPendingRequests()));
        emitter.emit((ServiceEventBuilder)builder.setMetric("mergeBuffer/used", (Number)this.mergeBufferPool.getUsedResourcesCount()));
        GroupByStatsProvider.AggregateStats statsContainer = this.groupByStatsProvider.getStatsSince();
        if (statsContainer.getMergeBufferQueries() > 0L) {
            emitter.emit((ServiceEventBuilder)builder.setMetric("mergeBuffer/queries", (Number)statsContainer.getMergeBufferQueries()));
            emitter.emit((ServiceEventBuilder)builder.setMetric("mergeBuffer/acquisitionTimeNs", (Number)statsContainer.getMergeBufferAcquisitionTimeNs()));
        }
        if (statsContainer.getSpilledQueries() > 0L) {
            emitter.emit((ServiceEventBuilder)builder.setMetric("groupBy/spilledQueries", (Number)statsContainer.getSpilledQueries()));
            emitter.emit((ServiceEventBuilder)builder.setMetric("groupBy/spilledBytes", (Number)statsContainer.getSpilledBytes()));
        }
        if (statsContainer.getMergeDictionarySize() > 0L) {
            emitter.emit((ServiceEventBuilder)builder.setMetric("groupBy/mergeDictionarySize", (Number)statsContainer.getMergeDictionarySize()));
        }
        return true;
    }
}

