/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CountingOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.client.DirectDruidClient;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.QueryExceptionCompat;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.TruncatedResponseContextException;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.ResponseContextConfig;

public abstract class QueryResultPusher {
    private static final Logger log = new Logger(QueryResultPusher.class);
    protected static final String RESULT_TRAILER_HEADERS = "X-Druid-Response-Complete";
    private final HttpServletRequest request;
    private final String queryId;
    private final ObjectMapper jsonMapper;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;
    private final QueryResource.QueryMetricCounter counter;
    private final MediaType contentType;
    private final Map<String, String> extraHeaders;
    private final Map<String, Object> queryContext;
    private final Map<String, String> trailerFields;
    private StreamingHttpResponseAccumulator accumulator;
    private AsyncContext asyncContext;
    private HttpServletResponse response;

    public QueryResultPusher(HttpServletRequest request, ObjectMapper jsonMapper, ResponseContextConfig responseContextConfig, DruidNode selfNode, QueryResource.QueryMetricCounter counter, String queryId, MediaType contentType, Map<String, String> extraHeaders, Map<String, Object> queryContext) {
        this.request = request;
        this.queryId = queryId;
        this.jsonMapper = jsonMapper;
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
        this.counter = counter;
        this.contentType = contentType;
        this.extraHeaders = extraHeaders;
        this.queryContext = queryContext;
        this.trailerFields = new HashMap<String, String>();
    }

    public abstract ResultsWriter start();

    public abstract void writeException(Exception var1, OutputStream var2) throws IOException;

    /*
     * Exception decompiling
     */
    @Nullable
    public Response push() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Response handleQueryException(ResultsWriter resultsWriter, QueryException e) {
        return this.handleDruidException(resultsWriter, DruidException.fromFailure((DruidException.Failure)new QueryExceptionCompat(e)));
    }

    private void incrementQueryCounterForException(DruidException e) {
        switch (e.getCategory()) {
            case INVALID_INPUT: 
            case UNAUTHORIZED: 
            case RUNTIME_FAILURE: 
            case CANCELED: {
                this.counter.incrementInterrupted();
                break;
            }
            case CAPACITY_EXCEEDED: 
            case UNSUPPORTED: 
            case UNCATEGORIZED: 
            case DEFENSIVE: {
                this.counter.incrementFailed();
                break;
            }
            case TIMEOUT: {
                this.counter.incrementTimedOut();
            }
        }
    }

    private Response handleDruidException(ResultsWriter resultsWriter, DruidException e) {
        this.incrementQueryCounterForException(e);
        if (resultsWriter != null) {
            long bytesWritten = this.accumulator != null ? this.accumulator.getNumBytesSent() : 0L;
            resultsWriter.recordFailure((Exception)((Object)e), bytesWritten);
            if (this.accumulator != null && this.accumulator.isInitialized()) {
                if (this.queryContext != null && Boolean.parseBoolean(String.valueOf(this.queryContext.get("writeExceptionBodyAsResponseRow")))) {
                    try {
                        this.accumulator.writer.writeRow((Object)e);
                        this.accumulator.writer.writeResponseEnd();
                    }
                    catch (IOException ioException) {
                        log.warn((Throwable)ioException, "Suppressing IOException thrown writing error response for query [%s]", new Object[]{this.queryId});
                    }
                }
                this.trailerFields.put("X-Error-Message", e.getMessage());
                this.trailerFields.put(RESULT_TRAILER_HEADERS, "false");
                return null;
            }
        }
        if (this.response == null) {
            return QueryResultPusher.handleDruidExceptionBeforeResponseStarted(e, this.contentType, (Map<String, String>)ImmutableMap.builder().putAll(this.extraHeaders).put((Object)"X-Druid-Query-Id", (Object)this.queryId).build());
        }
        if (this.response.isCommitted()) {
            QueryResource.NO_STACK_LOGGER.warn((Throwable)e, "Response was committed without the accumulator writing anything!?", new Object[0]);
        }
        this.response.setStatus(e.getStatusCode());
        this.response.setHeader("Content-Type", this.contentType.toString());
        try (ServletOutputStream out = this.response.getOutputStream();){
            this.writeException((Exception)((Object)e), (OutputStream)out);
        }
        catch (IOException ioException) {
            log.warn((Throwable)ioException, "Suppressing IOException thrown sending error response for query [%s]", new Object[]{this.queryId});
        }
        return null;
    }

    public static Response handleDruidExceptionBeforeResponseStarted(DruidException e, MediaType contentType, Map<String, String> extraHeaders) {
        Response.ResponseBuilder bob = Response.status((int)e.getStatusCode()).type(contentType).entity((Object)new ErrorResponse(e));
        for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
            bob.header(entry.getKey(), (Object)entry.getValue());
        }
        return bob.build();
    }

    private /* synthetic */ Map lambda$push$0() {
        return this.trailerFields;
    }

    public static interface ResultsWriter
    extends Closeable {
        @Nullable
        public Response.ResponseBuilder start();

        public QueryResponse<Object> getQueryResponse();

        public Writer makeWriter(OutputStream var1) throws IOException;

        public void recordSuccess(long var1);

        public void recordFailure(Exception var1, long var2);
    }

    public class StreamingHttpResponseAccumulator
    implements Accumulator<Response, Object>,
    Closeable {
        private final ResponseContext responseContext;
        private final ResultsWriter resultsWriter;
        private boolean closed = false;
        private boolean initialized = false;
        private CountingOutputStream out = null;
        private Writer writer = null;

        public StreamingHttpResponseAccumulator(ResponseContext responseContext, ResultsWriter resultsWriter) {
            this.responseContext = responseContext;
            this.resultsWriter = resultsWriter;
        }

        public long getNumBytesSent() {
            return this.out == null ? 0L : this.out.getCount();
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void initialize() {
            if (this.closed) {
                throw new ISE("Cannot reinitialize after closing.", new Object[0]);
            }
            if (!this.initialized) {
                QueryResultPusher.this.response.setStatus(200);
                Object entityTag = this.responseContext.remove(ResponseContext.Keys.ETAG);
                if (entityTag != null) {
                    QueryResultPusher.this.response.setHeader("ETag", entityTag.toString());
                }
                DirectDruidClient.removeMagicResponseContextFields(this.responseContext);
                this.validateAndWriteResponseContextHeader();
                QueryResultPusher.this.response.setContentType(QueryResultPusher.this.contentType.toString());
                QueryResultPusher.this.response.setTrailerFields(() -> QueryResultPusher.this.trailerFields);
                try {
                    this.out = new CountingOutputStream((OutputStream)QueryResultPusher.this.response.getOutputStream());
                    this.writer = this.resultsWriter.makeWriter((OutputStream)this.out);
                }
                catch (IOException e) {
                    throw new RE((Throwable)e, "Problems setting up response stream for query[%s]!?", new Object[]{QueryResultPusher.this.queryId});
                }
                try {
                    this.writer.writeResponseStart();
                }
                catch (IOException e) {
                    throw new RE((Throwable)e, "Could not start the response for query[%s]!?", new Object[]{QueryResultPusher.this.queryId});
                }
                this.initialized = true;
            }
        }

        private void validateAndWriteResponseContextHeader() {
            ResponseContext.SerializationResult serializationResult;
            try {
                serializationResult = this.responseContext.serializeWith(QueryResultPusher.this.jsonMapper, QueryResultPusher.this.responseContextConfig.getMaxResponseContextHeaderSize());
            }
            catch (JsonProcessingException e) {
                log.info((Throwable)e, "Problem serializing to JSON!?", new Object[0]);
                serializationResult = new ResponseContext.SerializationResult("Could not serialize", "Could not serialize");
            }
            if (serializationResult.isTruncated()) {
                String logToPrint = StringUtils.format((String)"Response Context truncated for id [%s]. Full context is [%s].", (Object[])new Object[]{QueryResultPusher.this.queryId, serializationResult.getFullResult()});
                if (QueryResultPusher.this.responseContextConfig.shouldFailOnTruncatedResponseContext()) {
                    log.error(logToPrint, new Object[0]);
                    throw new QueryInterruptedException((Throwable)new TruncatedResponseContextException("Serialized response context exceeds the max size[%s]", new Object[]{QueryResultPusher.this.responseContextConfig.getMaxResponseContextHeaderSize()}), QueryResultPusher.this.selfNode.getHostAndPortToUse());
                }
                log.warn(logToPrint, new Object[0]);
            }
            QueryResultPusher.this.response.setHeader("X-Druid-Response-Context", serializationResult.getResult());
        }

        @Nullable
        public Response accumulate(Response retVal, Object in) {
            if (!this.initialized) {
                this.initialize();
            }
            try {
                this.writer.writeRow(in);
            }
            catch (IOException ex) {
                QueryResource.NO_STACK_LOGGER.warn((Throwable)ex, "Unable to write query response.", new Object[0]);
                throw new RuntimeException(ex);
            }
            return null;
        }

        public void flush() throws IOException {
            if (!this.initialized) {
                this.initialize();
            }
            this.validateAndWriteResponseContextHeader();
            this.writer.writeResponseEnd();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.initialized && this.writer != null) {
                this.writer.close();
            }
            this.closed = true;
        }
    }

    public static interface Writer
    extends Closeable {
        public void writeResponseStart() throws IOException;

        public void writeRow(Object var1) throws IOException;

        public void writeResponseEnd() throws IOException;
    }
}

